/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.intogen;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gitools.intogen.IntogenServiceException;
import org.gitools.persistence.PersistenceUtils;

public class IntogenService {
    private static IntogenService service;

    private IntogenService() {
    }

    public static IntogenService getDefault() {
        if (service == null) {
            service = new IntogenService();
        }
        return service;
    }

    public void queryFromPOST(File folder, String prefix, URL action, List<String[]> properties, IProgressMonitor monitor) throws IntogenServiceException {
        try {
            ZipEntry ze;
            monitor.begin("Querying for data ...", 1);
            URLConnection urlConn = action.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());
            StringBuilder content = new StringBuilder();
            boolean first = true;
            for (String[] entry : properties) {
                if (!first) {
                    content.append('&');
                }
                first = false;
                content.append(entry[0]).append('=');
                content.append(URLEncoder.encode(entry[1], "UTF-8"));
            }
            printout.writeBytes(content.toString());
            printout.flush();
            printout.close();
            monitor.end();
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put("modulemap.tsv", prefix + "-oncomodules.tcm.gz");
            nameMap.put("oncomodules.tsv", prefix + "-annotations.tsv.gz");
            nameMap.put("modulemap.csv", prefix + "-oncomodules.tcm.gz");
            nameMap.put("oncomodules.csv", prefix + "-annotations.tsv.gz");
            nameMap.put("data.tsv", prefix + ".cdm.gz");
            nameMap.put("row.annotations.tsv", prefix + "-rows.tsv.gz");
            nameMap.put("column.annotations.tsv", prefix + "-columns.tsv.gz");
            monitor.begin("Downloading data ...", 1);
            ZipInputStream zin = new ZipInputStream(urlConn.getInputStream());
            while ((ze = zin.getNextEntry()) != null) {
                int count;
                IProgressMonitor mon = monitor.subtask();
                long totalKb = ze.getSize() / 1024L;
                String name = (String)nameMap.get(ze.getName());
                if (name == null) {
                    name = prefix + "." + ze.getName();
                }
                mon.begin("Extracting " + name + " ...", (int)ze.getSize());
                File outFile = new File(folder, name);
                if (!outFile.getParentFile().exists()) {
                    outFile.getParentFile().mkdirs();
                }
                OutputStream fout = PersistenceUtils.openOutputStream((File)outFile);
                int BUFFER_SIZE = 4096;
                byte[] data = new byte[4096];
                int partial = 0;
                while ((count = zin.read(data, 0, 4096)) != -1) {
                    fout.write(data, 0, count);
                    mon.info((partial += count) / 1024 + " Kb read");
                    mon.worked(count);
                }
                zin.closeEntry();
                fout.close();
                mon.end();
            }
            zin.close();
            monitor.end();
        }
        catch (IOException ex) {
            throw new IntogenServiceException(ex);
        }
    }
}

