/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.kegg.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.gitools.kegg.soap.KEGG;
import org.gitools.kegg.soap.KEGGBindingStub;
import org.gitools.kegg.soap.KEGGPortType;

public class KEGGLocator
extends Service
implements KEGG {
    private String KEGGPort_address = "http://soap.genome.jp/keggapi/request_v6.2.cgi";
    private String KEGGPortWSDDServiceName = "KEGGPort";
    private HashSet ports = null;

    public KEGGLocator() {
    }

    public KEGGLocator(EngineConfiguration config) {
        super(config);
    }

    public KEGGLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getKEGGPortAddress() {
        return this.KEGGPort_address;
    }

    public String getKEGGPortWSDDServiceName() {
        return this.KEGGPortWSDDServiceName;
    }

    public void setKEGGPortWSDDServiceName(String name) {
        this.KEGGPortWSDDServiceName = name;
    }

    @Override
    public KEGGPortType getKEGGPort() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.KEGGPort_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getKEGGPort(endpoint);
    }

    @Override
    public KEGGPortType getKEGGPort(URL portAddress) throws ServiceException {
        try {
            KEGGBindingStub _stub = new KEGGBindingStub(portAddress, this);
            _stub.setPortName(this.getKEGGPortWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setKEGGPortEndpointAddress(String address) {
        this.KEGGPort_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (KEGGPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                KEGGBindingStub _stub = new KEGGBindingStub(new URL(this.KEGGPort_address), this);
                _stub.setPortName(this.getKEGGPortWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("KEGGPort".equals(inputPortName)) {
            return this.getKEGGPort();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("SOAP/KEGG", "KEGG");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("SOAP/KEGG", "KEGGPort"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"KEGGPort".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setKEGGPortEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

