/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.kegg.modules;

import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.kegg.soap.Definition;
import org.gitools.modules.importer.Organism;
import org.gitools.modules.importer.RefImpl;

public class EnsemblKeggOrganism
extends RefImpl
implements Organism {
    private DatasetInfo ensemblDataset;
    private Definition keggDef;

    public EnsemblKeggOrganism(String id, String name, DatasetInfo dataset) {
        super(id, name);
        this.ensemblDataset = dataset;
    }

    public EnsemblKeggOrganism(String id, String name, Definition def) {
        super(id, name);
        this.keggDef = def;
    }

    public DatasetInfo getEnsemblDataset() {
        return this.ensemblDataset;
    }

    public void setEnsemblDataset(DatasetInfo ensemblDataset) {
        this.ensemblDataset = ensemblDataset;
    }

    public Definition getKeggDef() {
        return this.keggDef;
    }

    public void setKeggDef(Definition keggDef) {
        this.keggDef = keggDef;
    }

    public String getRef() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getRef()).append("[");
        if (this.ensemblDataset != null) {
            sb.append("ENSEMBL");
        }
        if (this.ensemblDataset != null && this.keggDef != null) {
            sb.append(", ");
        }
        if (this.keggDef != null) {
            sb.append("KEGG");
        }
        sb.append("]");
        return sb.toString();
    }
}

