/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.kegg.modules;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.BiomartServiceException;
import org.gitools.biomart.BiomartServiceFactory;
import org.gitools.biomart.idmapper.EnsemblMapper;
import org.gitools.biomart.queryhandler.BiomartQueryHandler;
import org.gitools.biomart.restful.model.Attribute;
import org.gitools.biomart.restful.model.AttributeCollection;
import org.gitools.biomart.restful.model.AttributeDescription;
import org.gitools.biomart.restful.model.AttributeGroup;
import org.gitools.biomart.restful.model.AttributePage;
import org.gitools.biomart.restful.model.Dataset;
import org.gitools.biomart.restful.model.DatasetInfo;
import org.gitools.biomart.restful.model.MartLocation;
import org.gitools.biomart.restful.model.Query;
import org.gitools.biomart.settings.BiomartSource;
import org.gitools.biomart.settings.BiomartSourceManager;
import org.gitools.idmapper.Mapper;
import org.gitools.idmapper.MappingData;
import org.gitools.idmapper.MappingEngine;
import org.gitools.kegg.idmapper.AllIds;
import org.gitools.kegg.idmapper.KeggGenesMapper;
import org.gitools.kegg.idmapper.KeggPathwaysMapper;
import org.gitools.kegg.modules.EnsemblKeggFeatureCategory;
import org.gitools.kegg.modules.EnsemblKeggModuleCategory;
import org.gitools.kegg.modules.EnsemblKeggOrganism;
import org.gitools.kegg.modules.EnsemblKeggVersion;
import org.gitools.kegg.soap.Definition;
import org.gitools.kegg.soap.KEGGLocator;
import org.gitools.kegg.soap.KEGGPortType;
import org.gitools.model.ModuleMap;
import org.gitools.modules.importer.FeatureCategory;
import org.gitools.modules.importer.ModuleCategory;
import org.gitools.modules.importer.ModulesImporter;
import org.gitools.modules.importer.ModulesImporterException;
import org.gitools.modules.importer.Organism;
import org.gitools.modules.importer.Version;
import org.gitools.obo.OBOEvent;
import org.gitools.obo.OBOEventTypes;
import org.gitools.obo.OBOStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnsemblKeggModulesImporter
implements ModulesImporter,
AllIds,
OBOEventTypes {
    private static Logger logger = LoggerFactory.getLogger(EnsemblKeggModulesImporter.class);
    public static final EnsemblKeggModuleCategory[] KEGG_MODULE_CATEGORIES = new EnsemblKeggModuleCategory[]{new EnsemblKeggModuleCategory("KEGG", "kegg:pathway", "KEGG Pathways")};
    public static final EnsemblKeggModuleCategory[] GO_MODULE_CATEGORIES = new EnsemblKeggModuleCategory[]{new EnsemblKeggModuleCategory("Ensembl", "go:bp", "GO Biological Processes"), new EnsemblKeggModuleCategory("Ensembl", "go:mf", "GO Molecular functions"), new EnsemblKeggModuleCategory("Ensembl", "go:cl", "GO Cellular locations")};
    private static final Map<String, String> goDescId = new HashMap<String, String>();
    private static final EnsemblKeggFeatureCategory[] COMMON_FEATURES;
    private static final Map<String, EnsemblKeggFeatureCategory> featMap;
    private EnsemblKeggVersion version;
    private EnsemblKeggOrganism organism;
    private EnsemblKeggModuleCategory modCategory;
    private EnsemblKeggFeatureCategory featCategory;
    private boolean keggEnabled;
    private boolean goEnabled;
    private BiomartService biomartService;
    private MartLocation martLocation;
    private KEGGPortType keggService;
    private Organism[] cachedOrganisms;
    private ModuleCategory[] moduleCategories;
    private FeatureCategory[] cachedFeatures;
    private Map<String, EnsemblKeggFeatureCategory> keggFeatMap;
    private List<EnsemblKeggFeatureCategory> ensemblFeats;

    public EnsemblKeggModulesImporter(boolean keggEnabled, boolean goEnabled) {
        this.keggEnabled = keggEnabled;
        this.goEnabled = goEnabled;
        ArrayList<EnsemblKeggModuleCategory> mc = new ArrayList<EnsemblKeggModuleCategory>();
        if (keggEnabled) {
            mc.addAll(Arrays.asList(KEGG_MODULE_CATEGORIES));
        }
        if (goEnabled) {
            mc.addAll(Arrays.asList(GO_MODULE_CATEGORIES));
        }
        this.moduleCategories = mc.toArray(new ModuleCategory[mc.size()]);
    }

    private BiomartService getBiomartService() throws BiomartServiceException, ModulesImporterException {
        if (this.biomartService != null) {
            return this.biomartService;
        }
        if (this.version == null) {
            throw new ModulesImporterException("Ensembl biomart source not defined.");
        }
        this.biomartService = BiomartServiceFactory.createService((BiomartSource)this.version.getSource());
        return this.biomartService;
    }

    private MartLocation getMart() throws BiomartServiceException, ModulesImporterException {
        BiomartService bs = this.getBiomartService();
        List registry = bs.getRegistry();
        Iterator it = registry.iterator();
        this.martLocation = null;
        while (this.martLocation == null && it.hasNext()) {
            MartLocation m = (MartLocation)it.next();
            if (!m.getName().equals("ENSEMBL_MART_ENSEMBL")) continue;
            this.martLocation = m;
        }
        return this.martLocation;
    }

    private KEGGPortType getKeggService() throws ServiceException {
        if (this.keggService != null) {
            return this.keggService;
        }
        KEGGLocator locator = new KEGGLocator();
        this.keggService = locator.getKEGGPort();
        return this.keggService;
    }

    public Version[] getVersions() {
        LinkedList<EnsemblKeggVersion> sources = new LinkedList<EnsemblKeggVersion>();
        EnsemblKeggVersion latestVersion = null;
        for (BiomartSource src : BiomartSourceManager.getDefault().getSources()) {
            if (!src.getName().matches(".*ensembl.*")) continue;
            if (src.getName().matches(".*last.*")) {
                latestVersion = new EnsemblKeggVersion(src);
                continue;
            }
            sources.add(new EnsemblKeggVersion(src));
        }
        if (latestVersion != null) {
            sources.add(0, latestVersion);
        }
        return sources.toArray(new Version[sources.size()]);
    }

    public Organism[] getOrganisms() throws ModulesImporterException {
        if (this.cachedOrganisms != null) {
            return this.cachedOrganisms;
        }
        ArrayList<EnsemblKeggOrganism> orgs = new ArrayList<EnsemblKeggOrganism>();
        HashMap<String, EnsemblKeggOrganism> orgsMap = new HashMap<String, EnsemblKeggOrganism>();
        try {
            BiomartService bs = this.getBiomartService();
            MartLocation mart = this.getMart();
            List datasets = bs.getDatasets(mart);
            for (DatasetInfo ds : datasets) {
                String id = ds.getDisplayName().replaceAll(" genes [(].*[)]", "").toLowerCase();
                EnsemblKeggOrganism o = (EnsemblKeggOrganism)((Object)orgsMap.get(id));
                if (o == null) {
                    o = new EnsemblKeggOrganism(id, id, ds);
                    orgs.add(o);
                    orgsMap.put(id, o);
                    continue;
                }
                o.setEnsemblDataset(ds);
            }
            if (this.keggEnabled) {
                Definition[] orgDefs;
                KEGGPortType serv = this.getKeggService();
                for (Definition def : orgDefs = serv.list_organisms()) {
                    String id = def.getDefinition().replaceAll(" [(].*[)]", "").toLowerCase();
                    EnsemblKeggOrganism o = (EnsemblKeggOrganism)((Object)orgsMap.get(id));
                    if (o == null) {
                        o = new EnsemblKeggOrganism(id, id, def);
                        orgs.add(o);
                        orgsMap.put(id, o);
                        continue;
                    }
                    o.setKeggDef(def);
                }
                Iterator it = orgs.iterator();
                while (it.hasNext()) {
                    EnsemblKeggOrganism o = (EnsemblKeggOrganism)((Object)it.next());
                    if (o.getKeggDef() != null) continue;
                    it.remove();
                    orgsMap.remove(o.getId());
                }
            }
        }
        catch (Exception ex) {
            throw new ModulesImporterException((Throwable)ex);
        }
        this.cachedOrganisms = orgs.toArray(new EnsemblKeggOrganism[orgs.size()]);
        return this.cachedOrganisms;
    }

    public ModuleCategory[] getModuleCategories() {
        return this.moduleCategories;
    }

    public FeatureCategory[] getFeatureCategories() throws ModulesImporterException {
        if (this.cachedFeatures != null) {
            return this.cachedFeatures;
        }
        if (this.modCategory == null) {
            throw new ModulesImporterException("Module category not defined.");
        }
        ArrayList<EnsemblKeggFeatureCategory> feats = new ArrayList<EnsemblKeggFeatureCategory>();
        if (this.keggEnabled && this.organism.getKeggDef() != null) {
            String[] idList;
            this.keggFeatMap = new HashMap<String, EnsemblKeggFeatureCategory>();
            this.keggFeatMap.put("kegg:gene", featMap.get("kegg:gene"));
            feats.add(featMap.get("kegg:gene"));
            String orgId = this.organism.getKeggDef().getEntry_id();
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put("ensembl-" + orgId, "ensembl:gene");
            idMap.put("ncbi-geneid", "ncbi:gene");
            idMap.put("uniprot", "uniprot:protein");
            idMap.put("pdb", "pdb:protein");
            for (String id : idList = new String[]{"ensembl:gene", "ncbi:gene", "uniprot:protein", "pdb:protein"}) {
                EnsemblKeggFeatureCategory f = featMap.get(id);
                feats.add(f);
                this.keggFeatMap.put(id, f);
            }
        }
        if (this.organism.getEnsemblDataset() != null) {
            this.ensemblFeats = new ArrayList<EnsemblKeggFeatureCategory>();
            this.ensemblFeats.addAll(Arrays.asList(featMap.get("ensembl:gene"), featMap.get("ensembl:transcript"), featMap.get("ensembl:protein")));
            List attrs = null;
            try {
                BiomartService bs = this.getBiomartService();
                MartLocation mart = this.getMart();
                DatasetInfo dataset = this.organism.getEnsemblDataset();
                attrs = bs.getAttributes(mart, dataset);
            }
            catch (BiomartServiceException ex) {
                throw new ModulesImporterException((Throwable)ex);
            }
            HashMap<String, String> idmap = new HashMap<String, String>();
            idmap.put("ensembl_gene_id", "ensembl:gene");
            idmap.put("ensembl_transcript_id", "ensembl:transcript");
            idmap.put("pdb", "pdb:protein");
            idmap.put("entrezgene", "ncbi:gene");
            idmap.put("uniprot_swissprot_accession", "uniprot:protein");
            HashSet<String> idremove = new HashSet<String>(Arrays.asList("clone_based_ensembl_gene_name", "clone_based_ensembl_transcript_name", "clone_based_vega_gene_name", "clone_based_vega_transcript_name", "ox_ENS_LRG_transcript__dm_dbprimary_acc_1074", "ottt", "ottg", "shares_cds_with_enst", "shares_cds_with_ottt", "shares_cds_and_utr_with_ottt", "HGNC_mb001", "uniprot_sptrembl", "wikigene_description", "dbass3_id", "dbass3_name", "dbass5_id", "dbass5_name"));
            for (AttributePage p : attrs) {
                for (AttributeGroup g : p.getAttributeGroups()) {
                    for (AttributeCollection c : g.getAttributeCollections()) {
                        boolean isXref = c.getInternalName().equals("xrefs");
                        boolean isMicroarray = c.getInternalName().equals("microarray");
                        if (!isXref && !isMicroarray) continue;
                        logger.debug("Collection: " + c.getDisplayName() + " [" + c.getInternalName() + "]");
                        for (AttributeDescription a : c.getAttributeDescriptions()) {
                            EnsemblKeggFeatureCategory feat;
                            String iname;
                            String dname = a.getDisplayName();
                            if (a.isHidden() || dname == null || dname.isEmpty() || idremove.contains(iname = a.getInternalName())) continue;
                            String id = (String)idmap.get(iname);
                            if (id == null) {
                                id = "ensembl:" + iname;
                            }
                            if ((feat = featMap.get(id)) == null) {
                                String section = isMicroarray ? "Microarrays" : "Others";
                                feat = new EnsemblKeggFeatureCategory(section, id, dname);
                            }
                            this.ensemblFeats.add(feat);
                            logger.debug("\t" + dname + " [" + iname + "] --> " + feat.getId());
                        }
                    }
                }
            }
            feats.addAll(this.ensemblFeats);
        }
        HashSet<String> featIds = new HashSet<String>();
        Iterator featIt = feats.iterator();
        while (featIt.hasNext()) {
            EnsemblKeggFeatureCategory feat = (EnsemblKeggFeatureCategory)((Object)featIt.next());
            if (featIds.contains(feat.getId())) {
                featIt.remove();
                continue;
            }
            featIds.add(feat.getId());
        }
        this.cachedFeatures = feats.toArray(new EnsemblKeggFeatureCategory[feats.size()]);
        return this.cachedFeatures;
    }

    public ModuleCategory getModuleCategory() {
        return this.modCategory;
    }

    public void setModuleCategory(ModuleCategory category) {
        this.modCategory = (EnsemblKeggModuleCategory)category;
        this.organism = null;
        this.featCategory = null;
        this.cachedOrganisms = null;
        this.cachedFeatures = null;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = (EnsemblKeggVersion)version;
        this.biomartService = null;
        this.cachedOrganisms = null;
        this.cachedFeatures = null;
    }

    public Organism getOrganism() {
        return this.organism;
    }

    public void setOrganism(Organism organismId) {
        this.organism = (EnsemblKeggOrganism)organismId;
        this.featCategory = null;
        this.cachedFeatures = null;
    }

    public FeatureCategory getFeatureCategory() {
        return this.featCategory;
    }

    public void setFeatCategory(FeatureCategory featCategory) {
        this.featCategory = (EnsemblKeggFeatureCategory)featCategory;
    }

    public ModuleMap importMap(IProgressMonitor monitor) throws ModulesImporterException {
        ModuleMap mmap = null;
        MappingEngine mapping = new MappingEngine();
        if (this.organism.getKeggDef() != null) {
            monitor.info("KEGG");
            String keggorg = this.organism.getKeggDef().getEntry_id();
            KEGGPortType ks = null;
            try {
                ks = this.getKeggService();
            }
            catch (Exception ex) {
                throw new ModulesImporterException((Throwable)ex);
            }
            mapping.addMapper("kegg:pathway", "kegg:gene", (Mapper)new KeggPathwaysMapper(ks, keggorg));
            for (Map.Entry<String, EnsemblKeggFeatureCategory> e : this.keggFeatMap.entrySet()) {
                mapping.addMapper("kegg:gene", e.getValue().getId(), (Mapper)new KeggGenesMapper(ks, keggorg));
            }
        }
        Integer numericRelease = null;
        String release = this.version.getSource().getRelease();
        if (release != null && !release.isEmpty()) {
            numericRelease = Integer.parseInt(release);
        }
        if (this.organism.getEnsemblDataset() != null) {
            monitor.info("Ensembl");
            BiomartService bs = null;
            try {
                bs = this.getBiomartService();
            }
            catch (BiomartServiceException ex) {
                throw new ModulesImporterException((Throwable)ex);
            }
            String dsName = this.organism.getEnsemblDataset().getName();
            String linkId = null;
            if (this.keggEnabled && this.organism.getKeggDef() != null && !this.keggFeatMap.containsKey("ensembl:gene")) {
                List<String> idList = Arrays.asList("ensembl:gene", "ncbi:gene", "pdb:protein", "uniprot:protein");
                Iterator<String> it = idList.iterator();
                while (linkId == null && it.hasNext()) {
                    String id = it.next();
                    if (!this.keggFeatMap.containsKey(id)) continue;
                    linkId = id;
                }
                if (linkId != null) {
                    mapping.addMapper(linkId, "ensembl:gene", (Mapper)new EnsemblMapper(bs, dsName));
                }
            } else {
                linkId = "ensembl:gene";
            }
            HashSet<String> sinks = new HashSet<String>();
            for (EnsemblKeggFeatureCategory f : this.ensemblFeats) {
                String id = f.getRef();
                if (id.equals(linkId)) continue;
                sinks.add(id);
            }
            for (String id : sinks) {
                mapping.addMapper(linkId, id, (Mapper)new EnsemblMapper(bs, dsName));
            }
            if (this.goEnabled) {
                if (numericRelease != null && numericRelease >= 62) {
                    for (String id : sinks) {
                        mapping.addMapper("go:id", id, (Mapper)new EnsemblMapper(bs, dsName));
                    }
                    mapping.addMapper("go:id", linkId, (Mapper)new EnsemblMapper(bs, dsName));
                } else {
                    for (String id : sinks) {
                        mapping.addMapper("go:bp", id, (Mapper)new EnsemblMapper(bs, dsName));
                        mapping.addMapper("go:mf", id, (Mapper)new EnsemblMapper(bs, dsName));
                        mapping.addMapper("go:cl", id, (Mapper)new EnsemblMapper(bs, dsName));
                    }
                    mapping.addMapper("go:bp", linkId, (Mapper)new EnsemblMapper(bs, dsName));
                    mapping.addMapper("go:mf", linkId, (Mapper)new EnsemblMapper(bs, dsName));
                    mapping.addMapper("go:cl", linkId, (Mapper)new EnsemblMapper(bs, dsName));
                }
            }
        }
        try {
            String src = this.modCategory.getId();
            Map<String, String> modDesc = null;
            String[] ids = null;
            MappingData data = null;
            if (this.isCategory(src, KEGG_MODULE_CATEGORIES)) {
                modDesc = this.retrieveKeggsModules(src, monitor.subtask());
            } else if (this.isCategory(src, GO_MODULE_CATEGORIES)) {
                if (numericRelease != null && numericRelease >= 62) {
                    modDesc = this.retrieveGoModulesEns62(src, monitor.subtask());
                    src = "go:id";
                } else {
                    modDesc = this.retrieveGoModules(src, monitor.subtask());
                }
            } else {
                throw new ModulesImporterException("Unknown category id: " + src);
            }
            ids = modDesc.keySet().toArray(new String[modDesc.size()]);
            data = mapping.run(ids, src, this.featCategory.getId(), monitor);
            if (!monitor.isCancelled()) {
                boolean plainGo;
                if (!src.equals(data.getSrcNode().getId()) || !this.featCategory.getId().equals(data.getDstNode().getId())) {
                    monitor.exception((Throwable)new ModulesImporterException("There was an unexpected mapping error."));
                }
                Map<String, Set<String>> tree = null;
                boolean bl = plainGo = this.goEnabled && (this.modCategory.getId().equals("go:bp") || this.modCategory.getId().equals("go:mf") || this.modCategory.getId().equals("go:cl"));
                if (plainGo) {
                    tree = this.retrieveGoTree(monitor);
                    data = this.plainGoData(data, tree, monitor);
                } else {
                    tree = new HashMap<String, Set<String>>();
                }
                mmap = new ModuleMap(data.getMap(), modDesc, tree);
                mmap.setOrganism(this.organism.getId());
                mmap.setModuleCategory(this.modCategory.getId());
                mmap.setItemCategory(this.featCategory.getId());
            }
        }
        catch (Exception ex) {
            throw new ModulesImporterException((Throwable)ex);
        }
        return mmap;
    }

    private Map<String, String> retrieveKeggsModules(String src, IProgressMonitor monitor) throws ModulesImporterException {
        HashMap<String, String> desc = new HashMap<String, String>();
        monitor.begin("Getting KEGG pathways ...", 1);
        try {
            Definition[] pathwaysDefs;
            String keggorg = this.organism.getKeggDef().getEntry_id();
            KEGGPortType ks = this.getKeggService();
            for (Definition d : pathwaysDefs = ks.list_pathways(keggorg)) {
                desc.put(d.getEntry_id(), d.getDefinition());
            }
        }
        catch (Exception ex) {
            throw new ModulesImporterException((Throwable)ex);
        }
        monitor.end();
        return desc;
    }

    private Map<String, String> retrieveGoModulesEns62(final String src, IProgressMonitor monitor) throws ModulesImporterException {
        final HashMap<String, String> desc = new HashMap<String, String>();
        monitor.begin("Getting Gene Ontology names ...", 1);
        BiomartService bs = null;
        try {
            bs = this.getBiomartService();
            Query q = EnsemblMapper.createQuery((String)this.organism.getEnsemblDataset().getName(), (String)EnsemblMapper.getInternalName((String)"go:id"), (String)goDescId.get("go:id"));
            Attribute a = new Attribute();
            a.setName("namespace_1003");
            ((Dataset)q.getDatasets().get(0)).getAttribute().add(a);
            bs.queryTable(q, new BiomartQueryHandler(){

                public void begin() throws Exception {
                }

                public void line(String[] fields) throws Exception {
                    if (fields.length == 3 && (src.equals("go:cl") && fields[2].equals("cellular_component") || src.equals("go:mf") && fields[2].equals("molecular_function") || src.equals("go:bp") && fields[2].equals("biological_process"))) {
                        desc.put(fields[0], fields[1]);
                    }
                }

                public void end() {
                }
            }, true, "", monitor.subtask());
        }
        catch (BiomartServiceException ex) {
            throw new ModulesImporterException((Throwable)ex);
        }
        monitor.end();
        return desc;
    }

    private Map<String, String> retrieveGoModules(String src, IProgressMonitor monitor) throws ModulesImporterException {
        final HashMap<String, String> desc = new HashMap<String, String>();
        monitor.begin("Getting Gene Ontology names ...", 1);
        BiomartService bs = null;
        try {
            bs = this.getBiomartService();
            Query q = EnsemblMapper.createQuery((String)this.organism.getEnsemblDataset().getName(), (String)EnsemblMapper.getInternalName((String)src), (String)goDescId.get(src));
            bs.queryTable(q, new BiomartQueryHandler(){

                public void begin() throws Exception {
                }

                public void line(String[] fields) throws Exception {
                    if (fields.length == 2) {
                        desc.put(fields[0], fields[1]);
                    }
                }

                public void end() {
                }
            }, true, "", monitor.subtask());
        }
        catch (BiomartServiceException ex) {
            throw new ModulesImporterException((Throwable)ex);
        }
        monitor.end();
        return desc;
    }

    private boolean isCategory(String src, EnsemblKeggModuleCategory[] categories) {
        for (EnsemblKeggModuleCategory c : categories) {
            if (!c.getId().equals(src)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Set<String>> retrieveGoTree(IProgressMonitor monitor) throws MalformedURLException, IOException {
        monitor.begin("Reading Gene Ontology graph ...", 1);
        URL url = new URL("ftp://ftp.geneontology.org/pub/go/ontology/gene_ontology.obo");
        OBOStreamReader oboReader = new OBOStreamReader(url);
        HashMap<String, Set<String>> tree = new HashMap<String, Set<String>>();
        OBOEvent evt = oboReader.nextEvent();
        while (evt != null) {
            while (evt != null && evt.getType() != 30) {
                evt = oboReader.nextEvent();
            }
            if (evt != null && evt.getStanzaName().equalsIgnoreCase("term")) {
                evt = oboReader.nextEvent();
                String id = null;
                HashSet<String> isA = new HashSet<String>();
                boolean obsolete = false;
                while (evt != null && evt.getType() != 30) {
                    if (evt != null && evt.getType() == 40) {
                        String tagName = evt.getTagName();
                        if (tagName.equalsIgnoreCase("id")) {
                            id = evt.getTagContents();
                        } else if (tagName.equalsIgnoreCase("is_a")) {
                            isA.add(evt.getTagContents());
                        } else if (tagName.equalsIgnoreCase("is_obsolete")) {
                            obsolete = evt.getTagContents().equalsIgnoreCase("true");
                        }
                        evt = oboReader.nextEvent();
                    }
                    while (evt != null && evt.getType() != 30 && evt.getType() != 40) {
                        evt = oboReader.nextEvent();
                    }
                }
                if (id == null || obsolete) continue;
                for (String parent : isA) {
                    HashSet<String> set = (HashSet<String>)tree.get(parent);
                    if (set == null) {
                        set = new HashSet<String>();
                        tree.put(parent, set);
                    }
                    set.add(id);
                }
                continue;
            }
            if (evt == null) continue;
            evt = oboReader.nextEvent();
        }
        monitor.end();
        return tree;
    }

    private MappingData plainGoData(MappingData data, Map<String, Set<String>> tree, IProgressMonitor monitor) throws MalformedURLException, IOException {
        monitor.begin("Plaining Gene Ontology hierarchy ...", 1);
        MappingData plainData = new MappingData(data.getSrcNode().getId(), data.getDstNode().getId());
        for (String id : data.getSrcIds()) {
            HashSet<String> dstIds = new HashSet<String>(data.get(id));
            this.plainGoTerm(id, new HashSet<String>(), dstIds, data.getMap(), tree);
            plainData.set(id, dstIds);
        }
        monitor.end();
        return plainData;
    }

    private void plainGoTerm(String id, Set<String> path, Set<String> dstIds, Map<String, Set<String>> map, Map<String, Set<String>> childrenTree) {
        if (path.contains(id)) {
            throw new RuntimeException("Circular reference in path " + path + " for term " + id);
        }
        Set<String> childrenList = childrenTree.get(id);
        if (childrenList == null) {
            return;
        }
        for (String child : childrenList) {
            Set<String> ids = map.get(child);
            if (ids == null) continue;
            dstIds.addAll(ids);
            HashSet<String> childPath = new HashSet<String>(path);
            childPath.add(id);
            this.plainGoTerm(child, childPath, dstIds, map, childrenTree);
        }
    }

    static {
        goDescId.put("go:bp", "name_1006");
        goDescId.put("go:mf", "go_molecular_function__dm_name_1006");
        goDescId.put("go:cl", "go_cellular_component__dm_name_1006");
        goDescId.put("go:id", "name_1006");
        COMMON_FEATURES = new EnsemblKeggFeatureCategory[]{new EnsemblKeggFeatureCategory("Genes", "kegg:gene", "KEGG Genes"), new EnsemblKeggFeatureCategory("Genes", "ncbi:gene", "NCBI Genes"), new EnsemblKeggFeatureCategory("Protein", "pdb:protein", "PDB"), new EnsemblKeggFeatureCategory("Protein", "uniprot:protein", "UniProt"), new EnsemblKeggFeatureCategory("Genes", "ensembl:gene", "Ensembl Genes"), new EnsemblKeggFeatureCategory("Genes", "ensembl:transcript", "Ensembl Transcripts"), new EnsemblKeggFeatureCategory("Protein", "ensembl:protein", "Ensembl Proteins")};
        featMap = new HashMap<String, EnsemblKeggFeatureCategory>();
        for (EnsemblKeggFeatureCategory f : COMMON_FEATURES) {
            featMap.put(f.getId(), f);
        }
    }
}

