/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.kegg.idmapper;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.gitools.idmapper.MappingContext;
import org.gitools.idmapper.MappingData;
import org.gitools.idmapper.MappingException;
import org.gitools.idmapper.MappingNode;
import org.gitools.kegg.idmapper.AbstractKeggMapper;
import org.gitools.kegg.idmapper.AllIds;
import org.gitools.kegg.soap.Definition;
import org.gitools.kegg.soap.KEGGPortType;

public class KeggPathwaysMapper
extends AbstractKeggMapper
implements AllIds {
    public KeggPathwaysMapper(KEGGPortType service, String organismId) {
        super("KeggPathways", false, true, service, organismId);
    }

    public MappingData map(MappingContext context, MappingData data, MappingNode src, MappingNode dst, IProgressMonitor monitor) throws MappingException {
        if (!"kegg:pathway".equals(src.getId())) {
            throw new MappingException("Unsupported mapping from " + src + " to " + dst);
        }
        if (data.isEmpty()) {
            monitor.begin("Getting KEGG pathways ...", 1);
            try {
                Definition[] pathwaysDefs;
                for (Definition d : pathwaysDefs = this.service.list_pathways(this.organismId)) {
                    data.put(d.getEntry_id(), d.getEntry_id());
                }
            }
            catch (RemoteException ex) {
                throw new MappingException((Throwable)ex);
            }
            monitor.end();
        }
        if (monitor.isCancelled()) {
            return null;
        }
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        Set dstIds = data.getDstIds();
        monitor.begin("Getting KEGG genes ...", dstIds.size());
        try {
            for (String dstId : dstIds) {
                monitor.info(dstId);
                if (monitor.isCancelled()) {
                    return null;
                }
                String[] genes = this.service.get_genes_by_pathway(dstId);
                map.put(dstId, new HashSet<String>(Arrays.asList(genes)));
                monitor.worked(1);
            }
        }
        catch (RemoteException ex) {
            throw new MappingException((Throwable)ex);
        }
        monitor.end();
        monitor.begin("Mapping KEGG pathways to KEGG genes ...", dstIds.size());
        data.map(map);
        monitor.end();
        return data;
    }
}

