/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.kegg.idmapper;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gitools.idmapper.MappingContext;
import org.gitools.idmapper.MappingData;
import org.gitools.idmapper.MappingException;
import org.gitools.idmapper.MappingNode;
import org.gitools.kegg.idmapper.AbstractKeggMapper;
import org.gitools.kegg.idmapper.AllIds;
import org.gitools.kegg.soap.KEGGPortType;
import org.gitools.kegg.soap.LinkDBRelation;

public class KeggGenesMapper
extends AbstractKeggMapper
implements AllIds {
    public static final String NCBI_DB = "ncbi-geneid";
    public static final String UNIPROT_DB = "uniprot";
    public static final String PDB_DB = "pdb";
    public static final String ENSEMBL_DB = "ensembl";
    private static final Map<String, String> fileKey = new HashMap<String, String>();

    public KeggGenesMapper(KEGGPortType service, String organismId) {
        super("KeggGenes", false, true, service, organismId);
    }

    public MappingData map(MappingContext context, MappingData data, MappingNode src, MappingNode dst, IProgressMonitor monitor) throws MappingException {
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        monitor.begin("Getting mapping information from KEGG ...", 1);
        try {
            String prefix = fileKey.get(dst.getId());
            if (!"kegg:gene".equals(src.getId()) || prefix == null) {
                throw new MappingException("Unsupported mapping from " + src + " to " + dst);
            }
            if (prefix.equals(ENSEMBL_DB)) {
                prefix = prefix + "-" + this.organismId;
            }
            int numGenes = this.service.get_number_of_genes_by_organism(this.organismId);
            LinkDBRelation[] relations = this.service.get_linkdb_by_entry(this.organismId, prefix, 0, numGenes);
            int plen = prefix.length() + 1;
            for (LinkDBRelation rel : relations) {
                String srcId = rel.getEntry_id1();
                String dstId = rel.getEntry_id2();
                HashSet<String> b = (HashSet<String>)map.get(srcId);
                if (b == null) {
                    b = new HashSet<String>();
                    map.put(srcId, b);
                }
                b.add(dstId.substring(plen));
            }
        }
        catch (Exception ex) {
            throw new MappingException((Throwable)ex);
        }
        monitor.end();
        monitor.begin("Mapping KEGG genes ...", 1);
        if (data.isEmpty()) {
            data.identity(map.keySet());
        }
        data.map(map);
        monitor.end();
        return data;
    }

    static {
        fileKey.put("ncbi:gene", NCBI_DB);
        fileKey.put("uniprot:protein", UNIPROT_DB);
        fileKey.put("pdb:protein", PDB_DB);
        fileKey.put("ensembl:gene", ENSEMBL_DB);
    }
}

