/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.obo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.LinkedList;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gitools.obo.OBOEvent;
import org.gitools.obo.OBOEventTypes;
import org.gitools.obo.OBOStream;

public class OBOStreamReader
implements OBOEventTypes {
    private static final Pattern STANZA_NAME_PATTERN = Pattern.compile("^\\[(.*)\\][ \\t]*(?:!(.*))?$");
    private static final Pattern LINE_COMMENT_PATTERN = Pattern.compile("^\\s*!(.*)$");
    private static final Pattern TAG_NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z_]$");
    private OBOStream stream;
    private Stack<OBOStream> streamStack;
    private LinkedList<OBOEvent> tokens;
    private boolean headerStarted;
    private boolean headerEnded;
    private boolean documentEnded;
    private String stanzaName;
    private String tagName;

    public OBOStreamReader(Reader reader) {
        this(new OBOStream(new BufferedReader(reader)));
    }

    public OBOStreamReader(URL baseUrl) throws IOException {
        this(new OBOStream(baseUrl));
    }

    private OBOStreamReader(OBOStream stream) {
        this.stream = stream;
        this.streamStack = new Stack();
        this.tokens = new LinkedList();
        this.tokens.offer(new OBOEvent(10, 0));
        this.headerStarted = false;
        this.headerEnded = false;
        this.documentEnded = false;
        this.stanzaName = null;
    }

    public OBOEvent nextEvent() throws IOException {
        if (this.tokens.size() > 0) {
            return this.tokens.poll();
        }
        while (this.tokens.size() == 0) {
            String line = this.stream.nextLine();
            int pos = this.stream.getLinePos();
            if (line == null) {
                if (!this.documentEnded) {
                    this.documentEnded = true;
                    this.tokens.offer(new OBOEvent(19, pos));
                    break;
                }
                return null;
            }
            Matcher stanzaMatcher = STANZA_NAME_PATTERN.matcher(line);
            Matcher commentMatcher = LINE_COMMENT_PATTERN.matcher(line);
            if (stanzaMatcher.matches()) {
                if (this.stanzaName == null && !this.headerEnded) {
                    this.tokens.offer(new OBOEvent(29, pos));
                    this.headerEnded = true;
                }
                String stzName = stanzaMatcher.group(1);
                this.tokens.offer(new OBOEvent(30, pos, stzName));
                this.stanzaName = stzName;
                continue;
            }
            if (commentMatcher.matches()) {
                this.tokens.offer(new OBOEvent(1, pos));
                continue;
            }
            if (this.stanzaName == null && !this.headerStarted) {
                this.tokens.offer(new OBOEvent(20, pos));
                this.headerStarted = true;
            }
            this.nextTag(line, pos);
        }
        return this.tokens.poll();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    private void nextTag(String line, int linepos) {
        int pos = line.indexOf(58);
        if (pos < 0) {
            this.tokens.offer(new OBOEvent(-1, linepos));
            return;
        }
        this.tagName = line.substring(0, pos);
        String content = line.substring(pos + 1);
        StringBuilder sb = new StringBuilder();
        this.escapeCharsAndRemoveComments(content, sb);
        content = sb.toString().trim();
        this.tokens.offer(new OBOEvent(40, linepos, this.stanzaName, this.tagName, content));
        this.tokens.offer(new OBOEvent(49, linepos, this.stanzaName, this.tagName, content));
    }

    private void escapeCharsAndRemoveComments(String line, StringBuilder sb) {
        int len = line.length();
        int pos = 0;
        block15: while (pos < len) {
            char c;
            if ((c = line.charAt(pos++)) == '!') {
                pos = len;
                continue;
            }
            if (c != '\\' || c == '\\' && pos == len - 1) {
                sb.append(c);
                continue;
            }
            c = line.charAt(pos++);
            switch (c) {
                case 'n': {
                    sb.append('\n');
                    continue block15;
                }
                case 'W': {
                    sb.append(' ');
                    continue block15;
                }
                case 't': {
                    sb.append('\t');
                    continue block15;
                }
                case ':': {
                    sb.append(':');
                    continue block15;
                }
                case ',': {
                    sb.append(',');
                    continue block15;
                }
                case '\"': {
                    sb.append('\"');
                    continue block15;
                }
                case '\\': {
                    sb.append('\\');
                    continue block15;
                }
                case '(': {
                    sb.append('(');
                    continue block15;
                }
                case ')': {
                    sb.append(')');
                    continue block15;
                }
                case '[': {
                    sb.append('[');
                    continue block15;
                }
                case ']': {
                    sb.append(']');
                    continue block15;
                }
                case '{': {
                    sb.append('{');
                    continue block15;
                }
                case '}': {
                    sb.append('}');
                    continue block15;
                }
            }
            sb.append(c);
        }
    }
}

