/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.obo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.net.ftp.FTPClient;

class OBOStream {
    private URL baseUrl;
    private BufferedReader reader;
    private int linePos;

    public OBOStream(BufferedReader reader) {
        this.reader = reader;
        this.linePos = 0;
    }

    public OBOStream(URL baseUrl) throws IOException {
        this.baseUrl = baseUrl;
        if (baseUrl.getProtocol().equalsIgnoreCase("ftp")) {
            FTPClient ftp = new FTPClient();
            if (baseUrl.getPort() != -1) {
                ftp.connect(baseUrl.getHost(), baseUrl.getPort());
            } else {
                ftp.connect(baseUrl.getHost());
            }
            ftp.login("anonymous", "");
            ftp.enterLocalPassiveMode();
            ftp.setControlKeepAliveTimeout(60L);
            InputStream is = ftp.retrieveFileStream(baseUrl.getPath());
            this.reader = new BufferedReader(new InputStreamReader(is));
        } else {
            this.reader = new BufferedReader(new InputStreamReader(baseUrl.openStream()));
        }
        this.linePos = 0;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public String nextLine() throws IOException {
        String line = this.readLine();
        while (line != null && this.isEmptyLine(line)) {
            line = this.readLine();
        }
        return line;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    private String readLine() throws IOException {
        if (this.reader == null) {
            return null;
        }
        StringBuilder completeLine = new StringBuilder();
        String line = this.reader.readLine();
        ++this.linePos;
        if (line != null) {
            line = line.trim();
        }
        while (line != null && line.endsWith("\\")) {
            line = line.substring(0, line.length() - 1);
            completeLine.append(line);
            line = this.reader.readLine();
            ++this.linePos;
            if (line == null) continue;
            line = line.trim();
        }
        if (line != null) {
            completeLine.append(line);
        }
        if (line == null && completeLine.length() == 0) {
            return null;
        }
        return completeLine.toString();
    }

    private boolean isEmptyLine(String line) {
        return line.replaceAll("\\s", "").isEmpty();
    }
}

