/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.biomart.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.gitools.biomart.settings.BiomartSource;
import org.gitools.biomart.settings.BiomartSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiomartSourceManager {
    private static Logger logger = LoggerFactory.getLogger(BiomartSourceManager.class);
    private static final String userPath = System.getProperty("user.home", ".");
    private static final String configPath = userPath + File.separator + ".gitools";
    private static final String configFileName = "biomart-sources.xml";
    private static final String configFile = configPath + File.separator + "biomart-sources.xml";
    private static BiomartSourceManager instance;
    private static BiomartSources biomartSources;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BiomartSourceManager getDefault() {
        if (instance == null) {
            try {
                File file = new File(configFile);
                InputStreamReader reader = file.exists() ? new FileReader(configFile) : new InputStreamReader(BiomartSourceManager.class.getResourceAsStream("/biomart-sources.xml"));
                instance = BiomartSourceManager.load(reader);
                ((Reader)reader).close();
            }
            catch (Exception ex) {
                logger.error("Error in biomart user configuration file");
            }
            finally {
                if (instance == null || instance.getSources().size() == 0) {
                    logger.error("Instance not initialised. Loading default configuration");
                    BiomartSource src = new BiomartSource();
                    src.setName("Biomart Central Portal");
                    src.setDescription("BioMart Central Portal");
                    src.setVersion("0.7");
                    src.setRestPath("/biomart/martservice");
                    src.setWsdlPath("/biomart/martwsdl");
                    src.setHost("www.biomart.org");
                    src.setPort("80");
                    instance = new BiomartSourceManager();
                    instance.addSource(src);
                }
            }
        }
        return instance;
    }

    private static BiomartSourceManager load(Reader reader) {
        BiomartSourceManager settings = new BiomartSourceManager();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{BiomartSources.class});
            Unmarshaller u = context.createUnmarshaller();
            settings.addSources((BiomartSources)u.unmarshal(reader));
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Biomart settings file doesn't exist: " + configFile);
            System.err.println("Created one with defaults.");
            settings = new BiomartSourceManager();
            settings.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            settings = new BiomartSourceManager();
        }
        return settings;
    }

    private BiomartSourceManager() {
    }

    public void save() {
        File path = new File(configPath);
        if (!path.exists()) {
            path.mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{BiomartSources.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)this, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<BiomartSource> getSources() {
        return biomartSources.getSources();
    }

    public void setSources(List<BiomartSource> sources) {
        biomartSources.setSources(sources);
    }

    private void addSource(BiomartSource source) {
        biomartSources.getSources().add(source);
    }

    private void addSources(BiomartSources sources) {
        biomartSources.getSources().addAll(sources.getSources());
    }

    static {
        biomartSources = new BiomartSources();
    }
}

