/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.biomart.queryhandler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import org.gitools.biomart.queryhandler.BiomartQueryHandler;

public class TsvFileQueryHandler
implements BiomartQueryHandler {
    private File file;
    private boolean compressionEnabled;
    private PrintWriter writer;

    public TsvFileQueryHandler(File file, boolean compresssionEnabled) {
        this.file = file;
        this.compressionEnabled = compresssionEnabled;
    }

    @Override
    public void begin() throws Exception {
        OutputStream stream = new FileOutputStream(this.file);
        if (this.compressionEnabled) {
            stream = new GZIPOutputStream(stream);
        }
        this.writer = new PrintWriter(stream);
    }

    @Override
    public void line(String[] rowFields) {
        if (rowFields.length > 0) {
            this.writer.print(rowFields[0]);
            for (int i = 1; i < rowFields.length; ++i) {
                this.writer.print('\t');
                this.writer.print(rowFields[i]);
            }
            this.writer.println();
        }
    }

    @Override
    public void end() {
        this.writer.close();
    }
}

