/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.biomart.idmapper;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gitools.biomart.BiomartService;
import org.gitools.biomart.idmapper.AllIds;
import org.gitools.biomart.queryhandler.BiomartQueryHandler;
import org.gitools.biomart.restful.model.Attribute;
import org.gitools.biomart.restful.model.Dataset;
import org.gitools.biomart.restful.model.Query;
import org.gitools.idmapper.AbstractMapper;
import org.gitools.idmapper.MappingContext;
import org.gitools.idmapper.MappingData;
import org.gitools.idmapper.MappingException;
import org.gitools.idmapper.MappingNode;

public class EnsemblMapper
extends AbstractMapper
implements AllIds {
    private BiomartService service;
    private String dataset;
    private static final Map<String, String> inameMap = new HashMap<String, String>();

    public EnsemblMapper(BiomartService service, String dataset) {
        super("Ensembl", false, true);
        this.service = service;
        this.dataset = dataset;
    }

    public MappingData map(MappingContext context, MappingData data, MappingNode src, MappingNode dst, IProgressMonitor monitor) throws MappingException {
        String srcInternalName = EnsemblMapper.getInternalName(src.getId());
        String dstInternalName = EnsemblMapper.getInternalName(dst.getId());
        if (srcInternalName == null || dstInternalName == null) {
            throw new MappingException("Unsupported mapping from " + src + " to " + dst);
        }
        monitor.begin("Getting mappings from Ensembl ...", 1);
        final HashMap map = new HashMap();
        Query q = EnsemblMapper.createQuery(this.dataset, srcInternalName, dstInternalName);
        try {
            this.service.queryModule(q, new BiomartQueryHandler(){

                @Override
                public void begin() throws Exception {
                }

                @Override
                public void end() {
                }

                @Override
                public void line(String[] rowFields) throws Exception {
                    String srcf = rowFields[0];
                    String dstf = rowFields[1];
                    HashSet<String> items = (HashSet<String>)map.get(srcf);
                    if (items == null) {
                        items = new HashSet<String>();
                        map.put(srcf, items);
                    }
                    items.add(dstf);
                }
            }, monitor);
        }
        catch (Exception ex) {
            throw new MappingException((Throwable)ex);
        }
        monitor.end();
        monitor.begin("Mapping Ensembl IDs...", 1);
        if (data.isEmpty()) {
            data.identity(map.keySet());
        }
        data.map(map);
        monitor.end();
        return data;
    }

    public static String getInternalName(String id) {
        String iname = inameMap.get(id);
        if (iname == null && id.startsWith("ensembl:")) {
            return id.substring(8);
        }
        return iname;
    }

    public static Query createQuery(String dataset, String srcInternalName, String dstInternalName) {
        Query q = new Query();
        q.setVirtualSchemaName("default");
        q.setUniqueRows(1);
        Dataset ds = new Dataset();
        ds.setName(dataset);
        List<Attribute> attrs = ds.getAttribute();
        Attribute srcAttr = new Attribute();
        srcAttr.setName(srcInternalName);
        attrs.add(srcAttr);
        Attribute dstAttr = new Attribute();
        dstAttr.setName(dstInternalName);
        attrs.add(dstAttr);
        q.getDatasets().add(ds);
        return q;
    }

    static {
        inameMap.put("ensembl:gene", "ensembl_gene_id");
        inameMap.put("ensembl:transcript", "ensembl_transcript_id");
        inameMap.put("ensembl:protein", "ensembl_peptide_id");
        inameMap.put("pdb:protein", "pdb");
        inameMap.put("ncbi:refseq", "embl");
        inameMap.put("ncbi:gene", "entrezgene");
        inameMap.put("ncbi:unigene", "unigene");
        inameMap.put("uniprot:protein", "uniprot_swissprot_accession");
        inameMap.put("go:bp", "go_biological_process_id");
        inameMap.put("go:mf", "go_molecular_function_id");
        inameMap.put("go:cl", "go_cellular_component_id");
        inameMap.put("go:id", "go_id");
    }
}

