/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.workspace;

import edu.upf.bg.progressmonitor.StreamProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.gitools.model.Project;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.gitools.workspace.Workspace;
import org.gitools.workspace.WorkspaceManagerException;

public class WorkspaceManager {
    private static final String WORKSPACE_FILE_NAME = "workspace.xml";
    private static WorkspaceManager instance;
    protected File xmlPath;
    protected Workspace workspace;

    public static final WorkspaceManager getDefault() {
        if (instance == null) {
            instance = new WorkspaceManager();
        }
        return instance;
    }

    public static final void setDefault(WorkspaceManager ws) {
        instance = ws;
    }

    public static final WorkspaceManager createManager(File xmlPath) {
        File basePath = xmlPath.getParentFile();
        if (!basePath.exists()) {
            basePath.mkdirs();
        }
        WorkspaceManager wm = new WorkspaceManager(xmlPath);
        if (!xmlPath.exists()) {
            Workspace workspace = new Workspace(xmlPath);
            wm.saveWorkspace(workspace);
        }
        return wm;
    }

    public WorkspaceManager() {
        this(new File(new File(System.getProperty("user.home"), ".gitools"), WORKSPACE_FILE_NAME));
    }

    private WorkspaceManager(File xmlPath) {
        this.xmlPath = xmlPath;
    }

    public Workspace getWorkspace() {
        if (this.workspace == null) {
            if (!this.xmlPath.exists()) {
                this.workspace = new Workspace(this.xmlPath);
                this.saveWorkspace(this.workspace);
            } else {
                try {
                    this.workspace = this.loadWorkspace(this.xmlPath);
                }
                catch (WorkspaceManagerException e) {
                    throw new RuntimeException(e.getCause());
                }
            }
        }
        return this.workspace;
    }

    public Workspace loadWorkspace(File file) throws WorkspaceManagerException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Workspace.class});
            Unmarshaller u = context.createUnmarshaller();
            Workspace ws = (Workspace)u.unmarshal((InputStream)new FileInputStream(file));
            ws.setXmlPath(file);
            return ws;
        }
        catch (Exception ex) {
            throw new WorkspaceManagerException(ex);
        }
    }

    public void createWorkspace(File path) {
        this.saveWorkspace(new Workspace(path));
    }

    public void saveWorkspace(Workspace workspace) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Workspace.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            File path = workspace.getXmlPath().getParentFile();
            if (!path.exists()) {
                path.mkdirs();
            }
            m.marshal((Object)workspace, (OutputStream)new FileOutputStream(workspace.getXmlPath()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Project createProject(File basePath, Project project) throws PersistenceException {
        if (!basePath.exists()) {
            basePath.mkdirs();
        }
        File file = new File(basePath, "project.xml");
        StreamProgressMonitor monitor = new StreamProgressMonitor(System.out, true, true);
        PersistenceManager.getDefault().store(file, project, monitor);
        return project;
    }

    public Project createProject(File basePath) throws PersistenceException {
        return this.createProject(basePath, new Project());
    }
}

