/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.utils;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;

public class SerialClone {
    public static <T> T clone(T x) {
        try {
            return SerialClone.cloneX(x);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static <T> T cloneX(T x) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CloneOutput cout = new CloneOutput(bout);
        cout.writeObject(x);
        byte[] bytes = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        CloneInput cin = new CloneInput(bin, cout);
        Object clone = cin.readObject();
        return (T)clone;
    }

    public static <T> T xclone(T x) {
        XStream xstream = new XStream();
        String xml = xstream.toXML(x);
        return (T)xstream.fromXML(xml);
    }

    private static class CloneInput
    extends ObjectInputStream {
        private final CloneOutput output;

        CloneInput(InputStream in, CloneOutput output) throws IOException {
            super(in);
            this.output = output;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
            String found;
            Class<?> c = this.output.classQueue.poll();
            String expected = osc.getName();
            String string = found = c == null ? null : c.getName();
            if (!expected.equals(found)) {
                throw new InvalidClassException("Classes desynchronized: found " + found + " when expecting " + expected);
            }
            return c;
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
            return this.output.classQueue.poll();
        }
    }

    private static class CloneOutput
    extends ObjectOutputStream {
        Queue<Class<?>> classQueue = new LinkedList();

        CloneOutput(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> c) {
            this.classQueue.add(c);
        }

        @Override
        protected void annotateProxyClass(Class<?> c) {
            this.classQueue.add(c);
        }
    }
}

