/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.threads;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import org.gitools.threads.ThreadManager;
import org.gitools.threads.ThreadSlot;

public class ThreadQueue {
    private ArrayBlockingQueue<ThreadSlot> queue;
    final ExecutorService executor = ThreadManager.getExecutor();

    public ThreadQueue(int numSlots) {
        this.queue = new ArrayBlockingQueue(numSlots);
    }

    public void put(ThreadSlot threadSlot) throws InterruptedException {
        this.queue.put(threadSlot);
    }

    public ThreadSlot take() throws InterruptedException {
        return this.queue.take();
    }

    public void offer(ThreadSlot threadSlot) {
        this.queue.offer(threadSlot);
    }

    public void execute(final ThreadSlot threadSlot, final Runnable runnable) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                ThreadQueue.this.queue.offer(threadSlot);
            }
        });
    }
}

