/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.threads;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import edu.upf.bg.progressmonitor.NullProgressMonitor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ThreadManager {
    protected static ExecutorService executor = ThreadManager.createExecutor();
    protected static int nThreads = ThreadManager.getAvailableProcessors();

    public static void shutdown(IProgressMonitor monitor) {
        executor.shutdown();
        try {
            while (!executor.isTerminated()) {
                executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            monitor.debug("ThreadManager.shutdown() interrupted by exception: " + e.getMessage());
        }
        executor = ThreadManager.createExecutor();
    }

    private static ExecutorService createExecutor() {
        return Executors.newCachedThreadPool();
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static void setNumThreads(int nThreads) {
        if (ThreadManager.nThreads != nThreads) {
            ThreadManager.shutdown(new NullProgressMonitor());
            ThreadManager.nThreads = nThreads;
            executor = ThreadManager.createExecutor();
        }
    }

    public static int getNumThreads() {
        return nThreads;
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
}

