/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.table.model.impl;

import java.io.Serializable;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.xml.IndexArrayXmlAdapter;
import org.gitools.table.model.ITable;
import org.gitools.table.model.ITableColumn;
import org.gitools.table.model.Table;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"contents", "visibleRows", "visibleColumns"})
public class TableView
implements ITable,
Serializable {
    private static final long serialVersionUID = -3231844654295236093L;
    @XmlElement(type=Table.class)
    ITable contents;
    @XmlJavaTypeAdapter(value=IndexArrayXmlAdapter.class)
    private int[] visibleRows;
    @XmlJavaTypeAdapter(value=IndexArrayXmlAdapter.class)
    private int[] visibleColumns;

    public TableView() {
        this.visibleRows = new int[0];
        this.visibleColumns = new int[0];
    }

    public TableView(ITable table) {
        this.contents = table;
        this.visibleRows = new int[0];
        this.visibleColumns = new int[0];
    }

    @Override
    public IElementAdapter getCellColumnAdapter(int column) {
        return this.contents.getCellColumnAdapter(column);
    }

    @Override
    public ITableColumn getColumn(int index) {
        return this.contents.getColumn(index);
    }

    @Override
    public int getColumnCount() {
        return this.contents.getColumnCount();
    }

    @Override
    public String getHeader(int column) {
        return this.contents.getHeader(column);
    }

    @Override
    public int getRowCount() {
        return this.contents.getRowCount();
    }

    @Override
    public Object getValue(int row, int column) {
        return this.contents.getValue(row, column);
    }

    public ITable getContents() {
        return this.contents;
    }

    public void setContents(ITable contents) {
        this.contents = contents;
    }

    public int[] getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int[] visibleRows) {
        this.visibleRows = visibleRows;
    }

    public int[] getVisibleColumns() {
        return this.visibleColumns;
    }

    public void setVisibleColumns(int[] visibleColumns) {
        this.visibleColumns = visibleColumns;
    }

    public void beforeMarshal(Marshaller u) {
        boolean naturalOrder = true;
        int rows = this.visibleRows.length;
        int columns = this.visibleColumns.length;
        int maxSize = rows > columns ? rows : columns;
        for (int i = 0; i < maxSize && naturalOrder; ++i) {
            if (i < columns) {
                boolean bl = naturalOrder = i == this.visibleColumns[i];
            }
            if (i >= rows) continue;
            naturalOrder = i == this.visibleRows[i] && naturalOrder;
        }
        if (naturalOrder) {
            this.visibleColumns = null;
            this.visibleRows = null;
        }
    }

    public void afterMarshal(Marshaller u) {
        if (this.visibleColumns == null && this.visibleRows == null) {
            int count = this.contents.getRowCount();
            int[] rows = new int[count];
            for (int i = 0; i < count; ++i) {
                rows[i] = i;
            }
            this.setVisibleRows(rows);
            count = this.contents.getColumnCount();
            int[] columns = new int[count];
            for (int i = 0; i < count; ++i) {
                columns[i] = i;
            }
            this.setVisibleColumns(columns);
        }
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        int i;
        int count = 0;
        if (this.visibleRows.length == 0) {
            count = this.contents.getRowCount();
            int[] rows = new int[count];
            for (i = 0; i < count; ++i) {
                rows[i] = i;
            }
            this.setVisibleRows(rows);
        }
        if (this.visibleColumns.length == 0) {
            count = this.contents.getColumnCount();
            int[] columns = new int[count];
            for (i = 0; i < count; ++i) {
                columns[i] = i;
            }
            this.setVisibleColumns(columns);
        }
    }
}

