/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.table.model;

import edu.upf.bg.xml.adapter.ColorXmlAdapter;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.heatmap.header.HeatmapTextLabelsHeader;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.AbstractModel;
import org.gitools.model.Figure;
import org.gitools.model.decorator.impl.FormattedTextElementDecorator;
import org.gitools.model.xml.AbstractModelXmlAdapter;
import org.gitools.table.model.ITable;
import org.gitools.table.model.TableFormatException;
import org.gitools.table.model.impl.TableView;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="tableFigure")
public class TableFigure
extends Figure
implements Serializable {
    private static final long serialVersionUID = 9006041133309250290L;
    private TableView tableView;
    @XmlJavaTypeAdapter(value=AbstractModelXmlAdapter.class)
    private List<AbstractModel> cellDecorators;
    @XmlJavaTypeAdapter(value=AbstractModelXmlAdapter.class)
    private List<AbstractModel> headerDecorators;
    private boolean showGrid;
    @XmlJavaTypeAdapter(value=ColorXmlAdapter.class)
    private Color gridColor;
    private int rowSize;

    public TableFigure() {
        this.showGrid = true;
        this.gridColor = Color.WHITE;
        this.rowSize = 18;
        this.cellDecorators = new ArrayList<AbstractModel>();
        this.headerDecorators = new ArrayList<AbstractModel>();
    }

    public TableFigure(TableView tableView) {
        this.showGrid = true;
        this.gridColor = Color.WHITE;
        this.rowSize = 18;
        this.tableView = tableView;
        this.cellDecorators = new ArrayList<AbstractModel>();
        this.headerDecorators = new ArrayList<AbstractModel>();
        for (int i = 0; i < tableView.getColumnCount(); ++i) {
            IElementAdapter elementAdapter = tableView.getCellColumnAdapter(i);
            FormattedTextElementDecorator cellDecorator = new FormattedTextElementDecorator(elementAdapter);
            HeatmapTextLabelsHeader headerDecorator = new HeatmapTextLabelsHeader();
            this.cellDecorators.add(cellDecorator);
            this.headerDecorators.add(headerDecorator);
        }
    }

    public TableFigure(ITable table, List<AbstractModel> cellDecorators, List<AbstractModel> headerDecorators) throws TableFormatException {
        int columns = table.getColumnCount();
        if (columns != cellDecorators.size() || columns != headerDecorators.size()) {
            throw new TableFormatException("Wrong number of columns in table decorators");
        }
        this.cellDecorators = cellDecorators;
        this.headerDecorators = headerDecorators;
        this.showGrid = true;
        this.gridColor = Color.WHITE;
        this.rowSize = 18;
    }

    public void setDecorator(AbstractModel decorator, int column) {
        this.cellDecorators.set(column, decorator);
    }

    public void setHeaderDecorator(AbstractModel decorator, int column) {
        this.cellDecorators.set(column, decorator);
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public void setTableView(TableView tableView) {
        this.tableView = tableView;
    }

    public AbstractModel getHeaderDecorator(int column) {
        return this.headerDecorators.get(column);
    }

    public AbstractModel getDecorator(int column) {
        return this.cellDecorators.get(column);
    }
}

