/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.table.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gitools.matrix.model.AnnotationMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.matrix.model.Matrix;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.Artifact;
import org.gitools.model.xml.TableColumnXmlAdapter;
import org.gitools.persistence.xml.adapter.PersistenceReferenceXmlAdapter;
import org.gitools.table.model.ITable;
import org.gitools.table.model.ITableColumn;
import org.gitools.table.model.impl.AbstractTableColumn;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Table
extends Artifact
implements ITable,
Serializable {
    private int rowCount = 0;
    @XmlJavaTypeAdapter(value=PersistenceReferenceXmlAdapter.class)
    private IMatrix matrix;
    @XmlJavaTypeAdapter(value=PersistenceReferenceXmlAdapter.class)
    private AnnotationMatrix annotations;
    @XmlElementWrapper(name="columns")
    @XmlElement(name="column")
    @XmlJavaTypeAdapter(value=TableColumnXmlAdapter.class)
    private List<ITableColumn> columns;

    public Table() {
        this.columns = new ArrayList<ITableColumn>();
    }

    public Table(Matrix matrix, AnnotationMatrix annotations) {
        this.rowCount = matrix.getRowCount();
        this.columns = new ArrayList<ITableColumn>();
        this.matrix = matrix;
        this.annotations = annotations;
    }

    public void addColumn(ITableColumn column) {
        this.columns.add(column);
    }

    @Override
    public IElementAdapter getCellColumnAdapter(int column) {
        return this.columns.get(column).getAdapter();
    }

    @Override
    public ITableColumn getColumn(int index) {
        return this.columns.get(index);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public String getHeader(int column) {
        return this.columns.get(column).getHeader();
    }

    @Override
    public Object getValue(int row, int column) {
        return this.columns.get(column).getValue(row);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void removeColumn(int index) {
        this.columns.remove(index);
    }

    public void setAnnotations(AnnotationMatrix annotations) {
        this.annotations = annotations;
    }

    public AnnotationMatrix getAnnotations() {
        return this.annotations;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public IMatrix getMatrix() {
        return this.matrix;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        for (int i = 0; i < this.columns.size(); ++i) {
            AbstractTableColumn col = (AbstractTableColumn)((Object)this.columns.get(i));
            col.setTable(this);
        }
    }
}

