/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test.results;

import org.gitools.matrix.model.element.AttributeDef;
import org.gitools.stats.test.results.CommonResult;

public class BinomialResult
extends CommonResult {
    public Distribution distribution;
    public int observed;
    public double expectedMean;
    public double expectedStdev;
    public double probability;

    public BinomialResult() {
        super(0, 0.0, 0.0, 0.0);
        this.observed = 0;
        this.expectedStdev = 0.0;
        this.expectedMean = 0.0;
        this.probability = 0.0;
    }

    public BinomialResult(Distribution aprox, int n, double leftPvalue, double rightPvalue, double twoTailPvalue, int observed, double expectedMean, double expectedStdev, double p) {
        super(n, leftPvalue, rightPvalue, twoTailPvalue);
        this.distribution = aprox;
        this.observed = observed;
        this.expectedMean = expectedMean;
        this.expectedStdev = expectedStdev;
        this.probability = p;
    }

    @AttributeDef(id="observed", name="Observed events", description="Number of positive events observed")
    public int getObserved() {
        return this.observed;
    }

    public void setObserved(int observed) {
        this.observed = observed;
    }

    @AttributeDef(id="expected-mean", name="Expected mean", description="Number of positive events expected by chance")
    public double getExpectedMean() {
        return this.expectedMean;
    }

    public void setExpectedMean(double expectedMean) {
        this.expectedMean = expectedMean;
    }

    @AttributeDef(id="expected-stdev", name="Expected stddev", description="Standard deviation of the number of positive events expected by chance")
    public double getExpectedStdev() {
        return this.expectedStdev;
    }

    public void setExpectedStdev(double expectedStdev) {
        this.expectedStdev = expectedStdev;
    }

    @AttributeDef(id="distribution", name="Distribution", description="Wich distribution has been used to do calculations (Binomial exact, Normal or Poisson)")
    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    @AttributeDef(id="probability", name="Probability", description="Population probability of a positive event")
    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double probability) {
        this.probability = probability;
    }

    public static enum Distribution {
        BINOMIAL,
        NORMAL,
        POISSON;

    }
}

