/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test.factory;

import java.util.HashMap;
import java.util.Map;
import org.gitools.model.ToolConfig;
import org.gitools.stats.test.Test;
import org.gitools.stats.test.factory.BinomialTestFactory;
import org.gitools.stats.test.factory.FisherTestFactory;
import org.gitools.stats.test.factory.ZscoreTestFactory;

public abstract class TestFactory {
    public static final String TEST_NAME_PROPERTY = "test-name";
    public static final String ZSCORE_TEST = "zscore";
    public static final String BINOMIAL_TEST = "binomial";
    public static final String FISHER_EXACT_TEST = "fisher-exact";
    public static final String HYPERGEOMETRIC_TEST = "hypergeometric";
    public static final String CHI_SQUARE_TEST = "chi-square";
    private static final Map<String, TestEnum> testNameMap = new HashMap<String, TestEnum>();
    private static Map<String, TestConfigEnum> testAliases;
    protected ToolConfig toolConfig;

    public static TestFactory createFactory(ToolConfig config) {
        String testName = config.get(TEST_NAME_PROPERTY);
        TestEnum selectedTest = testNameMap.get(testName);
        if (selectedTest == null) {
            throw new IllegalArgumentException("Unknown test " + testName);
        }
        TestFactory testFactory = null;
        switch (selectedTest) {
            case zscore: {
                testFactory = new ZscoreTestFactory(config);
                break;
            }
            case binomial: {
                testFactory = new BinomialTestFactory(config);
                break;
            }
            case fisherExact: {
                testFactory = new FisherTestFactory(config);
                break;
            }
            case hypergeometric: {
                throw new IllegalArgumentException("Test not implemented yet: " + testName);
            }
            case chiSquare: {
                throw new IllegalArgumentException("Test not implemented yet: " + testName);
            }
        }
        return testFactory;
    }

    public static ToolConfig createToolConfig(String toolName, String configName) {
        TestConfigEnum selectedTest = testAliases.get(configName);
        if (selectedTest == null) {
            throw new IllegalArgumentException("Unknown test " + configName);
        }
        ToolConfig config = new ToolConfig(toolName);
        switch (selectedTest) {
            case zscoreMean: {
                config.put(TEST_NAME_PROPERTY, ZSCORE_TEST);
                config.put("samples", String.valueOf(10000));
                config.put("estimator", "mean");
                break;
            }
            case zscoreMedian: {
                config.put(TEST_NAME_PROPERTY, ZSCORE_TEST);
                config.put("samples", String.valueOf(10000));
                config.put("estimator", "median");
                break;
            }
            case binomial: 
            case binomialExact: {
                config.put(TEST_NAME_PROPERTY, BINOMIAL_TEST);
                config.put("aproximation", "exact");
                break;
            }
            case binomialNormal: {
                config.put(TEST_NAME_PROPERTY, BINOMIAL_TEST);
                config.put("aproximation", "normal");
                break;
            }
            case binomialPoisson: {
                config.put(TEST_NAME_PROPERTY, BINOMIAL_TEST);
                config.put("aproximation", "poisson");
                break;
            }
            case hypergeometric: {
                config.put(TEST_NAME_PROPERTY, HYPERGEOMETRIC_TEST);
                break;
            }
            case fisherExact: {
                config.put(TEST_NAME_PROPERTY, FISHER_EXACT_TEST);
                break;
            }
            case chiSquare: {
                config.put(TEST_NAME_PROPERTY, CHI_SQUARE_TEST);
            }
        }
        return config;
    }

    public TestFactory(ToolConfig config) {
        this.toolConfig = config;
    }

    public ToolConfig getTestConfig() {
        return this.toolConfig;
    }

    public abstract Test create();

    static {
        testNameMap.put(ZSCORE_TEST, TestEnum.zscore);
        testNameMap.put(BINOMIAL_TEST, TestEnum.binomial);
        testNameMap.put(FISHER_EXACT_TEST, TestEnum.fisherExact);
        testNameMap.put(HYPERGEOMETRIC_TEST, TestEnum.hypergeometric);
        testNameMap.put(CHI_SQUARE_TEST, TestEnum.chiSquare);
        testAliases = new HashMap<String, TestConfigEnum>();
        testAliases.put(ZSCORE_TEST, TestConfigEnum.zscoreMean);
        testAliases.put("zscore-mean", TestConfigEnum.zscoreMean);
        testAliases.put("zscore-median", TestConfigEnum.zscoreMedian);
        testAliases.put(BINOMIAL_TEST, TestConfigEnum.binomialExact);
        testAliases.put("binomial-exact", TestConfigEnum.binomialExact);
        testAliases.put("binomial-normal", TestConfigEnum.binomialNormal);
        testAliases.put("binomial-poisson", TestConfigEnum.binomialPoisson);
        testAliases.put("fisher", TestConfigEnum.fisherExact);
        testAliases.put("hyper-geom", TestConfigEnum.hypergeometric);
        testAliases.put("hyper-geometric", TestConfigEnum.hypergeometric);
        testAliases.put(HYPERGEOMETRIC_TEST, TestConfigEnum.hypergeometric);
        testAliases.put(CHI_SQUARE_TEST, TestConfigEnum.chiSquare);
    }

    private static enum TestConfigEnum {
        zscoreMean,
        zscoreMedian,
        binomial,
        binomialExact,
        binomialNormal,
        binomialPoisson,
        hypergeometric,
        fisherExact,
        chiSquare;

    }

    private static enum TestEnum {
        zscore,
        binomial,
        hypergeometric,
        fisherExact,
        chiSquare;

    }
}

