/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test;

import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import cern.jet.random.sampling.RandomSampler;
import org.gitools.stats.calc.Statistic;
import org.gitools.stats.test.ZscoreTest;

public class ZscoreWithSamplingTest
extends ZscoreTest {
    protected int numSamples;

    public ZscoreWithSamplingTest(int numSamples, Statistic statCalc) {
        super(statCalc);
        this.numSamples = numSamples;
    }

    @Override
    protected void infereMeanAndStdev(DoubleMatrix1D population, DoubleMatrix1D groupItems, ZscoreTest.PopulationStatistics expected) {
        int sampleSize = groupItems.size();
        long[] lindices = new long[sampleSize];
        int[] indices = new int[sampleSize];
        double sx = 0.0;
        double sx2 = 0.0;
        MersenneTwister randomEngine = new MersenneTwister();
        for (int i = 0; i < this.numSamples; ++i) {
            RandomSampler.sample((long)sampleSize, (long)population.size(), (int)sampleSize, (long)0L, (long[])lindices, (int)0, (RandomEngine)randomEngine);
            this.copyIndices(lindices, indices);
            double xi = this.statCalc.calc(population.viewSelection(indices));
            sx += xi;
            sx2 += xi * xi;
        }
        double N = this.numSamples;
        expected.mean = sx / N;
        expected.stdev = Math.sqrt(N * sx2 - sx * sx) / N;
    }

    private final void copyIndices(long[] lindices, int[] indices) {
        for (int j = 0; j < lindices.length; ++j) {
            indices[j] = (int)lindices[j];
        }
    }
}

