/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test;

import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.stat.Probability;
import org.gitools.stats.calc.Statistic;
import org.gitools.stats.test.AbstractTest;
import org.gitools.stats.test.results.CommonResult;
import org.gitools.stats.test.results.ZScoreResult;

public abstract class ZscoreTest
extends AbstractTest {
    protected Statistic statCalc;
    protected DoubleMatrix1D population;

    public ZscoreTest(Statistic statCalc) {
        this.statCalc = statCalc;
    }

    @Override
    public String getName() {
        return "zscore-" + this.statCalc.getName();
    }

    @Override
    public Class<? extends CommonResult> getResultClass() {
        return ZScoreResult.class;
    }

    @Override
    public void processPopulation(String name, DoubleMatrix1D population) {
        this.population = population;
    }

    @Override
    public CommonResult processTest(String condName, DoubleMatrix1D condItems, String groupName, int[] groupItemIndices) {
        DoubleMatrix1D groupItems = condItems.viewSelection(groupItemIndices).viewSelection(notNaNProc);
        double observed = this.statCalc.calc(groupItems);
        int sampleSize = groupItems.size();
        PopulationStatistics expected = new PopulationStatistics();
        this.infereMeanAndStdev(this.population, groupItems, expected);
        double zscore = (observed - expected.mean) / expected.stdev;
        double leftPvalue = Probability.normal((double)zscore);
        double rightPvalue = 1.0 - leftPvalue;
        double twoTailPvalue = (zscore <= 0.0 ? leftPvalue : rightPvalue) * 2.0;
        twoTailPvalue = twoTailPvalue > 1.0 ? 1.0 : twoTailPvalue;
        return new ZScoreResult(sampleSize, leftPvalue, rightPvalue, twoTailPvalue, observed, expected.mean, expected.stdev, zscore);
    }

    protected abstract void infereMeanAndStdev(DoubleMatrix1D var1, DoubleMatrix1D var2, PopulationStatistics var3);

    protected class PopulationStatistics {
        public double mean;
        public double stdev;

        protected PopulationStatistics() {
        }
    }
}

