/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test;

import cern.colt.matrix.DoubleMatrix1D;
import jsc.independentsamples.MannWhitneyTest;
import jsc.tests.H1;
import org.gitools.analysis.groupcomparison.GroupComparisonResult;
import org.gitools.stats.test.AbstractTest;
import org.gitools.stats.test.results.CommonResult;

public class MannWhitneyWilxoxonTest
extends AbstractTest {
    @Override
    public String getName() {
        return "Mann-Whitney-Wilcoxon";
    }

    public Class<? extends GroupComparisonResult> getResultClass() {
        return GroupComparisonResult.class;
    }

    @Override
    public void processPopulation(String name, DoubleMatrix1D population) {
    }

    public GroupComparisonResult processTest(double[] group1, double[] group2) {
        int i;
        int i2;
        int g1Nans = 0;
        int g2Nans = 0;
        for (i2 = 0; i2 < group1.length; ++i2) {
            if (!Double.isNaN(group1[i2])) continue;
            ++g1Nans;
        }
        for (i2 = 0; i2 < group2.length; ++i2) {
            if (!Double.isNaN(group2[i2])) continue;
            ++g2Nans;
        }
        double[] group1NoNan = new double[group1.length - g1Nans];
        double[] group2NoNan = new double[group2.length - g2Nans];
        int offset = 0;
        for (i = 0; i < group1.length; ++i) {
            if (!Double.isNaN(group1[i])) {
                group1NoNan[i - offset] = group1[i];
                continue;
            }
            ++offset;
        }
        offset = 0;
        for (i = 0; i < group2.length; ++i) {
            if (!Double.isNaN(group2[i])) {
                group2NoNan[i - offset] = group2[i];
                continue;
            }
            ++offset;
        }
        if (group1NoNan.length > 1 && group2NoNan.length > 1) {
            MannWhitneyTest mwwLeft = new MannWhitneyTest(group1NoNan, group2NoNan, H1.LESS_THAN);
            MannWhitneyTest mwwRight = new MannWhitneyTest(group1NoNan, group2NoNan, H1.GREATER_THAN);
            MannWhitneyTest mwwTwoTail = new MannWhitneyTest(group1NoNan, group2NoNan, H1.NOT_EQUAL);
            return new GroupComparisonResult(mwwLeft.getN(), group1NoNan.length, group2NoNan.length, mwwLeft.getSP(), mwwRight.getSP(), mwwTwoTail.getSP());
        }
        return new GroupComparisonResult(group1NoNan.length + group2NoNan.length, group1NoNan.length, group2NoNan.length, Double.NaN, Double.NaN, Double.NaN);
    }

    @Override
    public CommonResult processTest(String condName, DoubleMatrix1D condItems, String groupName, int[] groupItemIndices) {
        throw new UnsupportedOperationException("Not supported at all.");
    }
}

