/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test;

import cern.colt.matrix.DoubleMatrix1D;
import java.util.Arrays;
import org.gitools.stats.FisherExactTest;
import org.gitools.stats.test.AbstractTest;
import org.gitools.stats.test.results.CommonResult;
import org.gitools.stats.test.results.FisherResult;

public class FisherTest
extends AbstractTest {
    @Override
    public String getName() {
        return "fisher";
    }

    @Override
    public Class<? extends CommonResult> getResultClass() {
        return FisherResult.class;
    }

    @Override
    public void processPopulation(String name, DoubleMatrix1D population) {
    }

    @Override
    public CommonResult processTest(String condName, DoubleMatrix1D condItems, String groupName, int[] groupItemIndices) {
        int[] ctable = new int[4];
        this.calcContingencyTable(condItems, groupItemIndices, ctable);
        FisherExactTest fisher = new FisherExactTest(ctable);
        fisher.testContingencyTable();
        int N = ctable[0] + ctable[1];
        return new FisherResult(N, fisher.getLeftPValue(), fisher.getRightPValue(), fisher.getTwoTailPValue(), ctable[0], ctable[1], ctable[2], ctable[3]);
    }

    private void calcContingencyTable(DoubleMatrix1D condItems, int[] groupItems, int[] ctable) {
        for (int i = 0; i < 4; ++i) {
            ctable[i] = 0;
        }
        Arrays.sort(groupItems);
        int k = 0;
        for (int i = 0; i < condItems.size(); ++i) {
            int j;
            boolean belongsToGroup;
            double value = condItems.getQuick(i);
            boolean bl = belongsToGroup = k < groupItems.length && groupItems[k] == i;
            if (belongsToGroup) {
                ++k;
            }
            if (Double.isNaN(value)) continue;
            int n = j = value == 1.0 ? 0 : 1;
            if (!belongsToGroup) {
                j += 2;
            }
            int n2 = j;
            ctable[n2] = ctable[n2] + 1;
        }
    }
}

