/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.test;

import cern.colt.matrix.DoubleMatrix1D;
import cern.jet.stat.Probability;
import org.gitools.stats.calc.OnesCountStatistic;
import org.gitools.stats.calc.Statistic;
import org.gitools.stats.test.AbstractTest;
import org.gitools.stats.test.results.BinomialResult;
import org.gitools.stats.test.results.CommonResult;

public class BinomialTest
extends AbstractTest {
    private static final int exactSizeLimit = 100000;
    protected Statistic statCalc = new OnesCountStatistic();
    protected AproximationMode aproxMode;
    private double p;
    private BinomialAproximation aprox;

    public BinomialTest(AproximationMode aproxMode) {
        this.aproxMode = aproxMode;
        switch (aproxMode) {
            case onlyExact: {
                this.aprox = new BinomialAproximation(){

                    @Override
                    public CommonResult getResult(int observed, int n, double p, double expectedMean, double expectedStdev, double expectedVar) {
                        return BinomialTest.this.resultWithExact(observed, n, p, expectedMean, expectedStdev);
                    }
                };
                break;
            }
            case onlyNormal: {
                this.aprox = new BinomialAproximation(){

                    @Override
                    public CommonResult getResult(int observed, int n, double p, double expectedMean, double expectedStdev, double expectedVar) {
                        return BinomialTest.this.resultWithNormal(observed, n, p, expectedMean, expectedStdev);
                    }
                };
                break;
            }
            case onlyPoisson: {
                this.aprox = new BinomialAproximation(){

                    @Override
                    public CommonResult getResult(int observed, int n, double p, double expectedMean, double expectedStdev, double expectedVar) {
                        return BinomialTest.this.resultWithPoisson(observed, n, p, expectedMean, expectedStdev);
                    }
                };
                break;
            }
            case automatic: {
                this.aprox = new BinomialAproximation(){

                    @Override
                    public CommonResult getResult(int observed, int n, double p, double expectedMean, double expectedStdev, double expectedVar) {
                        if (n <= 100000) {
                            return BinomialTest.this.resultWithExact(observed, n, p, expectedMean, expectedStdev);
                        }
                        if (n >= 150 && expectedVar >= 0.9 * expectedMean) {
                            return BinomialTest.this.resultWithPoisson(observed, n, p, expectedMean, expectedStdev);
                        }
                        if ((double)n * p >= 5.0 && (double)n * (1.0 - p) >= 5.0) {
                            return BinomialTest.this.resultWithNormal(observed, n, p, expectedMean, expectedStdev);
                        }
                        return BinomialTest.this.resultWithExact(observed, n, p, expectedMean, expectedStdev);
                    }
                };
            }
        }
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append("binomial");
        switch (this.aproxMode) {
            case automatic: {
                break;
            }
            case onlyExact: {
                sb.append("-exact");
                break;
            }
            case onlyNormal: {
                sb.append("-normal");
                break;
            }
            case onlyPoisson: {
                sb.append("-poisson");
            }
        }
        return sb.toString();
    }

    @Override
    public Class<? extends CommonResult> getResultClass() {
        return BinomialResult.class;
    }

    @Override
    public void processPopulation(String name, DoubleMatrix1D population) {
        this.p = this.statCalc.calc(population) / (double)population.size();
    }

    @Override
    public CommonResult processTest(String condName, DoubleMatrix1D condItems, String groupName, int[] groupItemIndices) {
        DoubleMatrix1D groupItems = condItems.viewSelection(groupItemIndices).viewSelection(notNaNProc);
        int observed = (int)this.statCalc.calc(groupItems);
        int n = groupItems.size();
        double expectedMean = (double)n * this.p;
        double expectedVar = (double)n * this.p * (1.0 - this.p);
        double expectedStdev = Math.sqrt(expectedVar);
        return this.aprox.getResult(observed, n, this.p, expectedMean, expectedStdev, expectedVar);
    }

    public final CommonResult resultWithExact(int observed, int n, double p, double expectedMean, double expectedStdev) {
        double leftPvalue;
        double rightPvalue;
        double twoTailPvalue;
        if (n == 0) {
            twoTailPvalue = 1.0;
            rightPvalue = 1.0;
            leftPvalue = 1.0;
        } else {
            leftPvalue = Probability.binomial((int)observed, (int)n, (double)p);
            rightPvalue = observed > 0 ? Probability.binomialComplemented((int)(observed - 1), (int)n, (double)p) : 1.0;
            twoTailPvalue = leftPvalue + rightPvalue;
            twoTailPvalue = twoTailPvalue > 1.0 ? 1.0 : twoTailPvalue;
        }
        return new BinomialResult(BinomialResult.Distribution.BINOMIAL, n, leftPvalue, rightPvalue, twoTailPvalue, observed, expectedMean, expectedStdev, p);
    }

    public final CommonResult resultWithNormal(int observed, int n, double p, double expectedMean, double expectedStdev) {
        double zscore = ((double)observed - expectedMean) / expectedStdev;
        double leftPvalue = Probability.normal((double)zscore);
        double rightPvalue = 1.0 - leftPvalue;
        double twoTailPvalue = (zscore <= 0.0 ? leftPvalue : rightPvalue) * 2.0;
        twoTailPvalue = twoTailPvalue > 1.0 ? 1.0 : twoTailPvalue;
        return new BinomialResult(BinomialResult.Distribution.NORMAL, n, leftPvalue, rightPvalue, twoTailPvalue, observed, expectedMean, expectedStdev, p);
    }

    public final CommonResult resultWithPoisson(int observed, int n, double p, double expectedMean, double expectedStdev) {
        double twoTailPvalue;
        double rightPvalue;
        double leftPvalue;
        try {
            leftPvalue = Probability.poisson((int)observed, (double)expectedMean);
            rightPvalue = observed > 0 ? Probability.poissonComplemented((int)(observed - 1), (double)expectedMean) : 1.0;
            twoTailPvalue = ((double)observed <= expectedMean ? leftPvalue : rightPvalue) * 2.0;
            twoTailPvalue = twoTailPvalue > 1.0 ? 1.0 : twoTailPvalue;
        }
        catch (ArithmeticException e) {
            twoTailPvalue = Double.NaN;
            rightPvalue = Double.NaN;
            leftPvalue = Double.NaN;
        }
        return new BinomialResult(BinomialResult.Distribution.POISSON, n, leftPvalue, rightPvalue, twoTailPvalue, observed, expectedMean, expectedStdev, p);
    }

    private abstract class BinomialAproximation {
        private BinomialAproximation() {
        }

        public abstract CommonResult getResult(int var1, int var2, double var3, double var5, double var7, double var9);
    }

    public static enum AproximationMode {
        onlyExact,
        onlyNormal,
        onlyPoisson,
        automatic;

    }
}

