/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.mtc;

import java.util.HashMap;
import java.util.Map;
import org.gitools.stats.mtc.BenjaminiHochbergFdr;
import org.gitools.stats.mtc.Bonferroni;
import org.gitools.stats.mtc.MTC;

public class MTCFactory {
    private static final Map<String, Class<? extends MTC>> nameMap = new HashMap<String, Class<? extends MTC>>();
    private static final Map<Class<? extends MTC>, String> classMap = new HashMap<Class<? extends MTC>, String>();

    public static String[] getAvailableMtcNames() {
        String[] names = new String[nameMap.size()];
        nameMap.keySet().toArray(names);
        return names;
    }

    public static MTC createFromName(String name) {
        MTC mtc = null;
        try {
            Class<? extends MTC> cls = nameMap.get(name);
            mtc = cls.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
        return mtc;
    }

    static {
        nameMap.put("bonferroni", Bonferroni.class);
        nameMap.put("bh", BenjaminiHochbergFdr.class);
        for (Map.Entry<String, Class<? extends MTC>> e : nameMap.entrySet()) {
            classMap.put(e.getValue(), e.getKey());
        }
    }
}

