/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats.calc;

import cern.colt.matrix.DoubleMatrix1D;
import java.util.Arrays;
import org.gitools.stats.calc.Statistic;

public class MedianStatistic
implements Statistic {
    @Override
    public String getName() {
        return "median";
    }

    @Override
    public double calc(DoubleMatrix1D values) {
        int size = values.size();
        if (size == 0) {
            return Double.NaN;
        }
        if (size == 1) {
            return values.getQuick(0);
        }
        double[] tmp = new double[size];
        values.toArray(tmp);
        Arrays.sort(tmp);
        int middle = size / 2;
        double median = tmp[middle];
        if (size % 2 == 0) {
            median = (tmp[middle - 1] + median) / 2.0;
        }
        return median;
    }
}

