/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.stats;

import org.gitools.stats.HyperGeometric;

public class FisherExactTest {
    protected int a;
    protected int b;
    protected int c;
    protected int d;
    protected double leftPValue;
    protected double rightPValue;
    protected double twoTailPValue;
    protected HyperGeometric hyper = new HyperGeometric();

    public FisherExactTest(int[] ctable) {
        this.a = ctable[0];
        this.b = ctable[1];
        this.c = ctable[2];
        this.d = ctable[3];
    }

    public FisherExactTest(int a, int b, int c, int d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public double testContingencyTable(int a, int b, int c, int d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        return this.testContingencyTable();
    }

    public double testContingencyTable() {
        int n11 = this.a;
        int n1_ = this.a + this.b;
        int n_1 = this.a + this.c;
        int n = this.a + this.b + this.c + this.d;
        return this.internalTest(n11, n1_, n_1, n);
    }

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public int getC() {
        return this.c;
    }

    public int getD() {
        return this.d;
    }

    public double getLeftPValue() {
        return this.leftPValue;
    }

    public double getRightPValue() {
        return this.rightPValue;
    }

    public double getTwoTailPValue() {
        return this.twoTailPValue;
    }

    private double internalTest(int n11, int n1_, int n_1, int n) {
        double slarg;
        double sless;
        int min;
        int max = n1_;
        if (n_1 < max) {
            max = n_1;
        }
        if ((min = n1_ + n_1 - n) < 0) {
            min = 0;
        }
        if (min == max) {
            this.calcPValues(1.0, 1.0, 1.0, 1.0);
            return 1.0;
        }
        double prob = this.hyper.hyper0(n11, n1_, n_1, n);
        double sleft = 0.0;
        double p = this.hyper.hyper(min);
        int i = min + 1;
        while (p < 0.99999999 * prob) {
            sleft += p;
            p = this.hyper.hyper(i);
            ++i;
        }
        --i;
        if (p < 1.00000001 * prob) {
            sleft += p;
        } else {
            --i;
        }
        double sright = 0.0;
        p = this.hyper.hyper(max);
        int j = max - 1;
        while (p < 0.99999999 * prob) {
            sright += p;
            p = this.hyper.hyper(j);
            --j;
        }
        ++j;
        if (p < 1.00000001 * prob) {
            sright += p;
        } else {
            ++j;
        }
        if (Math.abs(i - n11) < Math.abs(j - n11)) {
            sless = sleft;
            slarg = 1.0 - sleft + prob;
        } else {
            sless = 1.0 - sright + prob;
            slarg = sright;
        }
        this.calcPValues(sleft, sright, sless, slarg);
        return prob;
    }

    private void calcPValues(double sleft, double sright, double sless, double slarg) {
        this.leftPValue = sless < 1.0 ? sless : 1.0;
        this.rightPValue = slarg < 1.0 ? slarg : 1.0;
        this.twoTailPValue = sleft + sright;
        if (this.twoTailPValue > 1.0) {
            this.twoTailPValue = 1.0;
        }
    }
}

