/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.xml.adapter;

import java.io.File;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.gitools.model.ResourceRef;
import org.gitools.persistence.PersistenceContext;
import org.gitools.persistence.PersistenceUtils;

public class ResourceRefXmlAdapter
extends XmlAdapter<ResourceRef, ResourceRef> {
    private PersistenceContext context;

    public ResourceRefXmlAdapter(PersistenceContext context) {
        this.context = context;
    }

    public ResourceRef unmarshal(ResourceRef v) throws Exception {
        if (v == null) {
            return null;
        }
        if (!PersistenceUtils.isAbsolute(v.getPath())) {
            File baseFile = new File(this.context.getBasePath());
            File path = new File(baseFile, v.getPath());
            v.setPath(path.getAbsolutePath());
        }
        return v;
    }

    public ResourceRef marshal(ResourceRef v) throws Exception {
        if (v == null) {
            return null;
        }
        File baseFile = new File(this.context.getBasePath());
        String path = PersistenceUtils.getRelativePath(baseFile.getAbsolutePath(), v.getPath());
        return new ResourceRef(v.getMime(), path);
    }
}

