/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.xml.adapter;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.gitools.persistence.PersistenceContext;
import org.gitools.persistence.PersistenceEntityContext;
import org.gitools.persistence.PersistenceManager;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.xml.adapter.PersistenceReferenceXmlElement;

public class PersistenceReferenceXmlAdapter<T>
extends XmlAdapter<PersistenceReferenceXmlElement, T> {
    private PersistenceContext context;

    public PersistenceReferenceXmlAdapter(PersistenceContext context) {
        this.context = context;
    }

    public T unmarshal(PersistenceReferenceXmlElement v) throws Exception {
        if (v.getPath() == null) {
            return null;
        }
        File baseFile = new File(this.context.getBasePath());
        boolean absolute = PersistenceUtils.isAbsolute(v.getPath());
        File file = absolute ? new File(v.getPath()) : new File(baseFile, v.getPath());
        String mimeType = v.getMime();
        if (mimeType == null) {
            mimeType = PersistenceManager.getDefault().getMimeFromFile(file.getName());
        }
        IProgressMonitor monitor = this.context.getMonitor();
        Object entity = null;
        if (this.context.isLoadReferences()) {
            entity = PersistenceManager.getDefault().load(file, mimeType, monitor);
            this.context.setEntityContext(entity, new PersistenceEntityContext(mimeType, file.getAbsolutePath()));
        }
        return (T)entity;
    }

    public PersistenceReferenceXmlElement marshal(T v) throws Exception {
        File linkFile;
        if (v == null) {
            return new PersistenceReferenceXmlElement();
        }
        PersistenceEntityContext entityContext = this.context.getEntityContext(v);
        String mimeType = entityContext.getMimeType();
        if (mimeType == null) {
            mimeType = PersistenceManager.getDefault().getMimeFromEntity(v.getClass());
        }
        File baseFile = new File(this.context.getBasePath());
        File file = new File(entityContext.getFilePath());
        PersistenceManager.FileRef fileRef = PersistenceManager.getDefault().getEntityFileRef(v);
        File file2 = linkFile = fileRef != null ? fileRef.getFile() : null;
        if (entityContext.isReferenceCacheEnabled() && linkFile != null) {
            file = linkFile;
        }
        String path = PersistenceUtils.getRelativePath(baseFile.getAbsolutePath(), file.getAbsolutePath());
        IProgressMonitor monitor = this.context.getMonitor();
        if (!entityContext.isReferenceCacheEnabled() || linkFile == null) {
            PersistenceManager.getDefault().store(file, v, monitor);
        }
        return new PersistenceReferenceXmlElement(mimeType, path);
    }
}

