/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.xml;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.gitools.analysis.overlapping.OverlappingAnalysis;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.matrix.model.IMatrix;
import org.gitools.model.ModuleMap;
import org.gitools.model.ResourceRef;
import org.gitools.persistence.PersistenceContext;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceManager;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.xml.AbstractXmlPersistence;
import org.gitools.persistence.xml.adapter.ResourceRefXmlAdapter;

public class OverlappingAnalysisXmlPersistence
extends AbstractXmlPersistence<OverlappingAnalysis> {
    public OverlappingAnalysisXmlPersistence() {
        super(OverlappingAnalysis.class);
        this.setPersistenceTitle("overlapping analysis");
    }

    @Override
    protected XmlAdapter<?, ?>[] createAdapters() {
        PersistenceContext context = this.getPersistenceContext();
        return new XmlAdapter[]{new ResourceRefXmlAdapter(context)};
    }

    @Override
    protected void beforeRead(File file, IProgressMonitor monitor) throws PersistenceException {
        File baseFile = file.getParentFile();
        PersistenceContext context = this.getPersistenceContext();
        context.setBasePath(baseFile.getAbsolutePath());
        context.setMonitor(monitor);
    }

    @Override
    protected void afterRead(File file, OverlappingAnalysis entity, IProgressMonitor monitor) throws PersistenceException {
        File baseFile = file.getParentFile();
        PersistenceContext context = this.getPersistenceContext();
        BaseMatrix data = null;
        if (context.isLoadReferences()) {
            data = this.loadData(baseFile, entity.getFilteredDataResource(), monitor);
        }
        entity.setData(data);
        IMatrix cellResults = null;
        if (context.isLoadReferences()) {
            cellResults = (IMatrix)this.load(baseFile, entity.getCellResultsResource(), monitor);
        }
        entity.setCellResults(cellResults);
    }

    @Override
    protected void beforeWrite(File file, OverlappingAnalysis entity, IProgressMonitor monitor) throws PersistenceException {
        File baseFile = file.getParentFile();
        String baseName = PersistenceUtils.getFileName(file.getName());
        PersistenceContext context = this.getPersistenceContext();
        context.setBasePath(baseFile.getAbsolutePath());
        context.setMonitor(monitor);
        PersistenceManager pm = this.getPersistenceManager();
        if (entity.isBinaryCutoffEnabled()) {
            String dataExt = pm.getExtensionFromEntity(entity.getData().getClass());
            File dataFile = new File(baseFile, baseName + "-data." + dataExt + ".gz");
            if (entity.getFilteredDataResource() == null) {
                entity.setFilteredDataResource(new ResourceRef(PersistenceManager.getDefault().getMimeFromEntity(entity.getData().getClass()), dataFile.getAbsolutePath()));
            }
            PersistenceManager.getDefault().store(dataFile, entity.getData(), monitor);
        } else {
            entity.setFilteredDataResource(entity.getSourceDataResource());
        }
        String cellResultsExt = pm.getExtensionFromEntity(entity.getCellResults().getClass());
        File cellResultsFile = new File(baseFile, baseName + "-results-cells." + cellResultsExt + ".gz");
        if (entity.getCellResultsResource() == null) {
            entity.setCellResultsResource(new ResourceRef(PersistenceManager.getDefault().getMimeFromEntity(entity.getCellResults().getClass()), cellResultsFile.getAbsolutePath()));
        }
        PersistenceManager.getDefault().store(cellResultsFile, entity.getCellResults(), monitor);
    }

    private Object load(File baseFile, ResourceRef resourceRef, IProgressMonitor monitor) throws PersistenceException {
        if (resourceRef == null) {
            return null;
        }
        String path = resourceRef.getPath();
        boolean absolute = PersistenceUtils.isAbsolute(path);
        File file = absolute ? new File(path) : new File(baseFile, path);
        String mimeType = resourceRef.getMime();
        if (mimeType == null) {
            mimeType = PersistenceManager.getDefault().getMimeFromFile(file.getName());
        }
        Object entity = PersistenceManager.getDefault().load(file, mimeType, monitor);
        return entity;
    }

    private BaseMatrix loadData(File baseFile, ResourceRef resourceRef, IProgressMonitor monitor) throws PersistenceException {
        Object obj = this.load(baseFile, resourceRef, monitor);
        BaseMatrix matrix = null;
        if (obj instanceof BaseMatrix) {
            matrix = (BaseMatrix)obj;
        } else if (obj instanceof ModuleMap) {
            matrix = MatrixUtils.moduleMapToMatrix((ModuleMap)obj);
        } else {
            throw new PersistenceException("Invalid MIME type for data: " + resourceRef.getMime());
        }
        return matrix;
    }
}

