/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.xml;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.gitools.heatmap.Heatmap;
import org.gitools.persistence.PersistenceContext;
import org.gitools.persistence.PersistenceEntityContext;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.xml.AbstractXmlPersistence;
import org.gitools.persistence.xml.adapter.PersistenceReferenceXmlAdapter;

public class HeatmapXmlPersistence
extends AbstractXmlPersistence<Heatmap> {
    public HeatmapXmlPersistence() {
        super(Heatmap.class);
    }

    @Override
    protected XmlAdapter<?, ?>[] createAdapters() {
        PersistenceContext context = this.getPersistenceContext();
        return new XmlAdapter[]{new PersistenceReferenceXmlAdapter(context)};
    }

    @Override
    protected void beforeWrite(File file, Heatmap entity, IProgressMonitor monitor) throws PersistenceException {
        file = file.getAbsoluteFile();
        File baseFile = file.getParentFile();
        String baseName = PersistenceUtils.getFileName(file.getName());
        PersistenceContext context = this.getPersistenceContext();
        context.setBasePath(baseFile.getAbsolutePath());
        context.setMonitor(monitor);
        context.setEntityContext(entity.getMatrixView().getContents(), new PersistenceEntityContext(new File(baseFile, baseName + ".data.gz").getAbsolutePath()));
        context.setEntityContext(entity.getRowDim().getAnnotations(), new PersistenceEntityContext(new File(baseFile, baseName + ".row.annotations.gz").getAbsolutePath()));
        context.setEntityContext(entity.getColumnDim().getAnnotations(), new PersistenceEntityContext(new File(baseFile, baseName + ".column.annotations.gz").getAbsolutePath()));
    }
}

