/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.xml;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.gitools.persistence.AbstractEntityPersistence;
import org.gitools.persistence.PersistenceContext;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;

public abstract class AbstractXmlPersistence<T>
extends AbstractEntityPersistence<T> {
    private static final long serialVersionUID = -3625243178449832555L;
    public static final String LOAD_REFERENCES_PROP = "load_references";
    private Class<T> entityClass;
    private XmlAdapter<?, ?>[] adapters;
    private boolean recursivePersistence;
    private String persistenceTitle;
    private PersistenceContext persistenceContext;

    public AbstractXmlPersistence(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.persistenceTitle = entityClass.getSimpleName();
        this.recursivePersistence = true;
        this.persistenceContext = new PersistenceContext();
    }

    public void setAdapters(XmlAdapter<?, ?>[] adapters) {
        this.adapters = adapters;
    }

    public XmlAdapter<?, ?>[] getAdapters() {
        return this.adapters;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void setPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String lr = properties.getProperty(LOAD_REFERENCES_PROP, "true");
        boolean loadReferences = lr == null || Boolean.parseBoolean(lr);
        this.persistenceContext.setLoadReferences(loadReferences);
    }

    protected XmlAdapter<?, ?>[] createAdapters() {
        return new XmlAdapter[0];
    }

    public boolean isRecursivePersistence() {
        return this.recursivePersistence;
    }

    public void setRecursivePersistence(boolean recirsivePersistence) {
        this.recursivePersistence = recirsivePersistence;
    }

    public String getPersistenceTitle() {
        return this.persistenceTitle;
    }

    public void setPersistenceTitle(String entityName) {
        this.persistenceTitle = entityName;
    }

    protected void beforeRead(File file, IProgressMonitor monitor) throws PersistenceException {
    }

    protected void afterRead(File file, T entity, IProgressMonitor monitor) throws PersistenceException {
    }

    @Override
    public T read(File file, IProgressMonitor monitor) throws PersistenceException {
        Object entity;
        this.beforeRead(file, monitor);
        try {
            Reader reader = PersistenceUtils.openReader(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.entityClass});
            Unmarshaller u = context.createUnmarshaller();
            if (this.adapters == null) {
                this.setAdapters(this.createAdapters());
            }
            for (XmlAdapter<?, ?> adapter : this.adapters) {
                u.setAdapter(adapter);
            }
            entity = u.unmarshal(reader);
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PersistenceException("Error reading resource: " + file.getName(), e);
        }
        this.afterRead(file, entity, monitor);
        return (T)entity;
    }

    protected void beforeWrite(File file, T entity, IProgressMonitor monitor) throws PersistenceException {
    }

    protected void afterWrite(File file, T entity, IProgressMonitor monitor) throws PersistenceException {
    }

    @Override
    public void write(File file, T entity, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Saving " + this.persistenceTitle + "...", 1);
        monitor.info("File: " + file.getAbsolutePath());
        this.beforeWrite(file, entity, monitor.subtask());
        try {
            Writer writer = PersistenceUtils.openWriter(file);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{this.entityClass});
            Marshaller m = context.createMarshaller();
            if (this.adapters == null) {
                this.setAdapters(this.createAdapters());
            }
            for (XmlAdapter<?, ?> adapter : this.adapters) {
                m.setAdapter(adapter);
            }
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal(entity, writer);
            writer.close();
        }
        catch (Exception e) {
            throw new PersistenceException("Error writing resource: " + file.getName(), e);
        }
        this.afterWrite(file, entity, monitor.subtask());
        monitor.end();
    }
}

