/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import cern.colt.matrix.ObjectFactory1D;
import cern.colt.matrix.ObjectMatrix1D;
import edu.upf.bg.csv.RawCsvWriter;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.apache.commons.csv.CSVParser;
import org.gitools.analysis.combination.CombinationResult;
import org.gitools.analysis.correlation.CorrelationResult;
import org.gitools.analysis.overlapping.OverlappingResult;
import org.gitools.datafilters.DoubleTranslator;
import org.gitools.matrix.model.ObjectMatrix;
import org.gitools.matrix.model.element.AbstractElementAdapter;
import org.gitools.matrix.model.element.ArrayElementAdapter;
import org.gitools.matrix.model.element.ArrayElementFactory;
import org.gitools.matrix.model.element.BeanElementAdapter;
import org.gitools.matrix.model.element.BeanElementFactory;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.matrix.model.element.IElementAttribute;
import org.gitools.matrix.model.element.IElementFactory;
import org.gitools.persistence.AbstractEntityPersistence;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.stats.test.results.BinomialResult;
import org.gitools.stats.test.results.FisherResult;
import org.gitools.stats.test.results.ZScoreResult;
import org.gitools.utils.CSVStrategies;

public class ObjectMatrixTextPersistence
extends AbstractEntityPersistence<ObjectMatrix> {
    public static final String META_COLUMN_LABELS = "labels.columns";
    public static final String META_ROW_LABELS = "labels.rows";
    public static final String META_ATTRIBUTES = "attributes";
    private static final String META_TAG = "#?";
    private static final String TYPE_TAG = "type";
    private static final Map<String, Class<?>> typeToClass;
    private static final Map<Class<?>, String> classToType;
    private static final Map<String, Class<?>> elementClasses;

    private static String getElementClassId(List<IElementAttribute> properties) {
        String[] ids = new String[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            ids[i] = properties.get(i).getId();
        }
        return ObjectMatrixTextPersistence.getElementClassId(ids);
    }

    private static String getElementClassId(String[] ids) {
        Object[] ids2 = new String[ids.length];
        System.arraycopy(ids, 0, ids2, 0, ids.length);
        Arrays.sort(ids2);
        StringBuilder sb = new StringBuilder();
        for (Object id : ids2) {
            sb.append(':').append((String)id);
        }
        return sb.toString();
    }

    @Override
    public String[] getMetadataKeys() {
        return new String[]{META_ATTRIBUTES};
    }

    @Override
    public Map<String, Object> readMetadata(File file, String[] keys, IProgressMonitor monitor) throws PersistenceException {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        for (String key : keys) {
            if (!META_ATTRIBUTES.equals(key)) continue;
            meta.put(META_ATTRIBUTES, this.readMetaAttributes(file, monitor));
        }
        return meta;
    }

    private List<IElementAttribute> readMetaAttributes(File file, IProgressMonitor monitor) throws PersistenceException {
        AbstractElementAdapter elementAdapter = null;
        Map<String, String> meta = this.readFormatAttributes(file, monitor);
        try {
            Reader reader = PersistenceUtils.openReader(file);
            CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
            String[] line = parser.getLine();
            if (line.length < 3) {
                throw new DataFormatException("Almost 3 columns expected.");
            }
            int numParams = line.length - 2;
            String[] paramNames = new String[numParams];
            System.arraycopy(line, 2, paramNames, 0, line.length - 2);
            Class<?> elementClass = null;
            if (meta.containsKey(TYPE_TAG)) {
                elementClass = typeToClass.get(meta.get(TYPE_TAG));
            }
            if (elementClass == null) {
                elementClass = elementClasses.get(ObjectMatrixTextPersistence.getElementClassId(paramNames));
            }
            elementAdapter = elementClass == null ? new ArrayElementAdapter(paramNames) : new BeanElementAdapter(elementClass);
            reader.close();
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
        return elementAdapter.getProperties();
    }

    @Override
    public ObjectMatrix read(File file, IProgressMonitor monitor) throws PersistenceException {
        ObjectMatrix resultsMatrix = new ObjectMatrix();
        this.read(file, resultsMatrix, monitor);
        return resultsMatrix;
    }

    public void read(File file, ObjectMatrix resultsMatrix, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Loading results ...", 1);
        monitor.info("File: " + file.getAbsolutePath());
        Map<String, String> meta = this.readFormatAttributes(file, monitor);
        try {
            Reader reader = PersistenceUtils.openReader(file);
            CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
            String[] line = parser.getLine();
            if (line.length < 3) {
                throw new DataFormatException("Almost 3 columns expected.");
            }
            int numParams = line.length - 2;
            String[] paramNames = new String[numParams];
            System.arraycopy(line, 2, paramNames, 0, numParams);
            Class<?> elementClass = null;
            if (meta.containsKey(TYPE_TAG)) {
                elementClass = typeToClass.get(meta.get(TYPE_TAG));
            }
            if (elementClass == null) {
                elementClass = elementClasses.get(ObjectMatrixTextPersistence.getElementClassId(paramNames));
            }
            AbstractElementAdapter elementAdapter = null;
            IElementFactory elementFactory = null;
            if (elementClass == null) {
                elementAdapter = new ArrayElementAdapter(paramNames);
                elementFactory = new ArrayElementFactory(paramNames.length);
            } else {
                elementAdapter = new BeanElementAdapter(elementClass);
                elementFactory = new BeanElementFactory(elementClass);
            }
            HashMap<String, Integer> attrIdmap = new HashMap<String, Integer>();
            int index = 0;
            for (IElementAttribute attr : elementAdapter.getProperties()) {
                attrIdmap.put(attr.getId(), index++);
            }
            HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
            HashMap<String, Integer> rowMap = new HashMap<String, Integer>();
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            while ((line = parser.getLine()) != null) {
                Integer rowIndex;
                String columnName = line[0];
                String rowName = line[1];
                Integer columnIndex = (Integer)columnMap.get(columnName);
                if (columnIndex == null) {
                    columnIndex = columnMap.size();
                    columnMap.put(columnName, columnIndex);
                }
                if ((rowIndex = (Integer)rowMap.get(rowName)) == null) {
                    rowIndex = rowMap.size();
                    rowMap.put(rowName, rowIndex);
                }
                Object element = elementFactory.create();
                for (int i = 2; i < line.length; ++i) {
                    Integer pix = (Integer)attrIdmap.get(paramNames[i - 2]);
                    if (pix == null) continue;
                    Object value = this.parsePropertyValue(elementAdapter.getProperty(pix), line[i]);
                    elementAdapter.setValue(element, pix, value);
                }
                list.add(new Object[]{new int[]{columnIndex, rowIndex}, element});
            }
            int numColumns = columnMap.size();
            int numRows = rowMap.size();
            ObjectMatrix1D columns = ObjectFactory1D.dense.make(numColumns);
            for (Map.Entry entry : columnMap.entrySet()) {
                columns.setQuick(((Integer)entry.getValue()).intValue(), entry.getKey());
            }
            ObjectMatrix1D rows = ObjectFactory1D.dense.make(numRows);
            for (Map.Entry entry : rowMap.entrySet()) {
                rows.setQuick(((Integer)entry.getValue()).intValue(), entry.getKey());
            }
            resultsMatrix.setColumns(columns);
            resultsMatrix.setRows(rows);
            resultsMatrix.makeCells();
            resultsMatrix.setCellAdapter(elementAdapter);
            for (Object[] result : list) {
                int[] coord = (int[])result[0];
                int columnIndex = coord[0];
                int rowIndex = coord[1];
                Object element = result[1];
                resultsMatrix.setCell(rowIndex, columnIndex, element);
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        monitor.end();
    }

    private Object parsePropertyValue(IElementAttribute property, String string) {
        Object value;
        block17: {
            Class<?> propertyClass = property.getValueClass();
            value = null;
            try {
                if (propertyClass.equals(Double.TYPE) || propertyClass.equals(Double.class)) {
                    value = Double.parseDouble(string);
                } else if (propertyClass.equals(Float.TYPE) || propertyClass.equals(Float.class)) {
                    value = Double.parseDouble(string);
                } else if (propertyClass.equals(Integer.TYPE) || propertyClass.equals(Integer.class)) {
                    value = Integer.parseInt(string);
                } else if (propertyClass.equals(Long.TYPE) || propertyClass.equals(Long.class)) {
                    value = Long.parseLong(string);
                } else if (propertyClass.isEnum()) {
                    ?[] cts;
                    for (Object o : cts = propertyClass.getEnumConstants()) {
                        if (!o.toString().equals(string)) continue;
                        value = o;
                    }
                } else {
                    value = string;
                }
            }
            catch (Exception e) {
                if (propertyClass.equals(Double.TYPE) || propertyClass.equals(Double.class)) {
                    value = Double.NaN;
                }
                if (propertyClass.equals(Float.TYPE) || propertyClass.equals(Float.class)) {
                    value = Float.valueOf(Float.NaN);
                }
                if (propertyClass.equals(Integer.TYPE) || propertyClass.equals(Integer.class)) {
                    value = new Integer(0);
                }
                if (propertyClass.equals(Long.TYPE) || propertyClass.equals(Long.class)) {
                    value = new Long(0L);
                }
                if (!propertyClass.isEnum()) break block17;
                value = string;
            }
        }
        return value;
    }

    @Override
    public void write(File file, ObjectMatrix results, IProgressMonitor monitor) throws PersistenceException {
        this.write(file, results, true, monitor);
    }

    public void write(File file, ObjectMatrix results, boolean orderByColumn, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Saving results...", results.getRowCount() * results.getColumnCount());
        monitor.info("File: " + file.getAbsolutePath());
        try {
            Writer writer = PersistenceUtils.openWriter(file);
            IElementAdapter cellAdapter = results.getCellAdapter();
            Class<?> elementClass = cellAdapter.getElementClass();
            String typeName = classToType.get(elementClass);
            if (typeName != null) {
                writer.write("#? type: " + typeName + "\n");
            }
            this.writeCells(writer, results, orderByColumn, monitor);
            writer.close();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            monitor.end();
        }
    }

    public void writeCells(Writer writer, ObjectMatrix resultsMatrix, boolean orderByColumn, IProgressMonitor monitor) {
        RawCsvWriter out = new RawCsvWriter(writer, CSVStrategies.TSV.getDelimiter(), CSVStrategies.TSV.getEncapsulator());
        IElementAdapter cellAdapter = resultsMatrix.getCellAdapter();
        out.writeQuotedValue("column");
        out.writeSeparator();
        out.writeQuotedValue("row");
        for (IElementAttribute prop : cellAdapter.getProperties()) {
            out.writeSeparator();
            out.writeQuotedValue(prop.getId());
        }
        out.writeNewLine();
        int numColumns = resultsMatrix.getColumnCount();
        int numRows = resultsMatrix.getRowCount();
        if (orderByColumn) {
            for (int colIndex = 0; colIndex < numColumns; ++colIndex) {
                for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
                    this.writeLine(out, resultsMatrix, colIndex, rowIndex, monitor);
                }
            }
        } else {
            for (int rowIndex = 0; rowIndex < numRows; ++rowIndex) {
                for (int colIndex = 0; colIndex < numColumns; ++colIndex) {
                    this.writeLine(out, resultsMatrix, colIndex, rowIndex, monitor);
                }
            }
        }
    }

    private void writeLine(RawCsvWriter out, ObjectMatrix resultsMatrix, int colIndex, int rowIndex, IProgressMonitor monitor) {
        Object element = resultsMatrix.getCell(rowIndex, colIndex);
        if (element == null) {
            return;
        }
        String colName = resultsMatrix.getColumnLabel(colIndex);
        String rowName = resultsMatrix.getRowLabel(rowIndex);
        out.writeQuotedValue(colName);
        out.writeSeparator();
        out.writeQuotedValue(rowName);
        IElementAdapter cellsAdapter = resultsMatrix.getCellAdapter();
        int numProperties = cellsAdapter.getPropertyCount();
        DoubleTranslator doubleTrans = new DoubleTranslator();
        for (int propIndex = 0; propIndex < numProperties; ++propIndex) {
            out.writeSeparator();
            Object value = cellsAdapter.getValue(element, propIndex);
            if (value instanceof Double) {
                Double v = (Double)value;
                out.write(doubleTrans.valueToString(v));
                continue;
            }
            if (value instanceof Integer) {
                out.writeValue(value.toString());
                continue;
            }
            out.writeQuotedValue(value.toString());
        }
        out.writeNewLine();
        monitor.worked(1);
    }

    private Map<String, String> readFormatAttributes(File file, IProgressMonitor monitor) throws PersistenceException {
        HashMap<String, String> meta = new HashMap<String, String>();
        try {
            BufferedReader r = new BufferedReader(PersistenceUtils.openReader(file));
            boolean done = false;
            String cl = null;
            while (!done && (cl = r.readLine()) != null) {
                if (cl.startsWith(META_TAG)) {
                    int pos = (cl = cl.substring(META_TAG.length()).trim()).indexOf(58);
                    if (pos <= 0 || pos >= cl.length() - 1) continue;
                    String key = cl.substring(0, pos).trim();
                    String value = cl.substring(pos + 1).trim();
                    meta.put(key, value);
                    continue;
                }
                done = true;
            }
            r.close();
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
        return meta;
    }

    static {
        Class[] classes;
        typeToClass = new HashMap();
        classToType = new HashMap();
        typeToClass.put("zscore-test", ZScoreResult.class);
        typeToClass.put("binomial-test", BinomialResult.class);
        typeToClass.put("fisher-test", FisherResult.class);
        typeToClass.put("correlation", CorrelationResult.class);
        typeToClass.put("combination", CombinationResult.class);
        typeToClass.put("overlapping", OverlappingResult.class);
        for (Map.Entry<String, Class<?>> e : typeToClass.entrySet()) {
            classToType.put(e.getValue(), e.getKey());
        }
        elementClasses = new HashMap();
        for (Class elementClass : classes = new Class[]{ZScoreResult.class, BinomialResult.class, FisherResult.class, CorrelationResult.class, CombinationResult.class, OverlappingResult.class}) {
            BeanElementAdapter adapter = new BeanElementAdapter(elementClass);
            elementClasses.put(ObjectMatrixTextPersistence.getElementClassId(adapter.getProperties()), elementClass);
        }
    }
}

