/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import org.apache.commons.csv.CSVParser;
import org.gitools._DEPRECATED.resources.FileResource;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceException;
import org.gitools.utils.CSVStrategies;

@Deprecated
public class ModuleMapTextSimplePersistence
extends FileResource {
    private static final long serialVersionUID = -6679172401494740813L;
    public static final int defaultMinModuleSize = 20;
    public static final int defaultMaxModuleSize = Integer.MAX_VALUE;

    public ModuleMapTextSimplePersistence(String fileName) {
        super(fileName);
    }

    public ModuleMapTextSimplePersistence(File file) {
        super(file);
    }

    public ModuleMap load(int minModuleSize, int maxModuleSize, String[] itemNames, boolean discardNonMappedItems, IProgressMonitor monitor) throws PersistenceException {
        ModuleMap moduleMap = new ModuleMap();
        this.load(moduleMap, minModuleSize, maxModuleSize, itemNames, discardNonMappedItems, monitor);
        return moduleMap;
    }

    public void load(ModuleMap moduleMap, int minModuleSize, int maxModuleSize, String[] itemNames, boolean includeNonMappedItems, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Reading modules ...", 1);
        monitor.info("Module size filter: minimum = " + minModuleSize + ", maximum = " + maxModuleSize);
        try {
            int i;
            int order;
            int start;
            TreeMap<String, Integer> itemNameToRowMapping = new TreeMap<String, Integer>();
            for (int i2 = 0; i2 < itemNames.length; ++i2) {
                itemNameToRowMapping.put(itemNames[i2], i2);
            }
            Reader reader = this.openReader();
            CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
            HashMap<String, SortedSet<Integer>> moduleItemsMap = new HashMap<String, SortedSet<Integer>>();
            this.readModuleMappings(parser, itemNameToRowMapping, moduleItemsMap);
            boolean[] itemHasMappings = new boolean[itemNames.length];
            parser = null;
            Set entries = moduleItemsMap.entrySet();
            String[] tmpModuleNames = new String[entries.size()];
            final int[][] tmpModuleItemIndices = new int[entries.size()][];
            int index = 0;
            for (Map.Entry entry : entries) {
                SortedSet indices = (SortedSet)entry.getValue();
                tmpModuleNames[index] = (String)entry.getKey();
                tmpModuleItemIndices[index] = new int[indices.size()];
                int[] ia = tmpModuleItemIndices[index];
                int i3 = 0;
                for (Integer idx : indices) {
                    ia[i3++] = idx;
                    itemHasMappings[idx.intValue()] = true;
                }
                ++index;
            }
            int numModules = entries.size();
            Integer[] moduleOrder = new Integer[numModules];
            for (int i4 = 0; i4 < moduleOrder.length; ++i4) {
                moduleOrder[i4] = i4;
            }
            Arrays.sort(moduleOrder, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    int l1 = tmpModuleItemIndices[o1].length;
                    int l2 = tmpModuleItemIndices[o2].length;
                    return l2 - l1;
                }
            });
            int end = numModules - 1;
            for (start = 0; start < numModules && tmpModuleItemIndices[moduleOrder[start]].length > maxModuleSize; ++start) {
                order = moduleOrder[start];
                tmpModuleNames[order] = null;
                tmpModuleItemIndices[order] = null;
            }
            while (end >= start && tmpModuleItemIndices[moduleOrder[end]].length < minModuleSize) {
                order = moduleOrder[end];
                tmpModuleNames[order] = null;
                tmpModuleItemIndices[order] = null;
                --end;
            }
            int fileNumModules = numModules;
            numModules = ++end - start;
            String[] moduleNames = new String[numModules];
            int[][] moduleItemIndices = new int[numModules][];
            int[] itemsOrder = new int[itemNames.length];
            Arrays.fill(itemsOrder, -1);
            int numItems = 0;
            for (i = start; i < end; ++i) {
                int order2 = moduleOrder[i];
                moduleNames[i - start] = tmpModuleNames[order2];
                moduleItemIndices[i - start] = tmpModuleItemIndices[order2];
                int[] indices = tmpModuleItemIndices[order2];
                for (int j = 0; j < indices.length; ++j) {
                    int idx = indices[j];
                    if (itemsOrder[idx] < 0) {
                        itemsOrder[idx] = numItems++;
                    }
                    indices[j] = itemsOrder[idx];
                }
            }
            for (i = 0; i < itemsOrder.length; ++i) {
                if (itemsOrder[i] >= 0 || !includeNonMappedItems && !itemHasMappings[i]) continue;
                itemsOrder[i] = numItems++;
            }
            String[] orderedItemNames = new String[numItems];
            for (int i5 = 0; i5 < itemsOrder.length; ++i5) {
                if (itemsOrder[i5] < 0) continue;
                orderedItemNames[itemsOrder[i5]] = itemNames[i5];
            }
            moduleMap.setModuleNames(moduleNames);
            moduleMap.setItemNames(orderedItemNames);
            moduleMap.setAllItemIndices(moduleItemIndices);
            monitor.info(numModules + " modules loaded");
            monitor.info(fileNumModules - numModules + " modules discarded");
            monitor.end();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    protected void readModuleMappings(CSVParser parser, Map<String, Integer> itemNameToRowMapping, Map<String, SortedSet<Integer>> moduleItemsMap) throws PersistenceException {
        try {
            String[] fields;
            while ((fields = parser.getLine()) != null) {
                if (fields.length < 2) {
                    throw new DataFormatException("At least 2 columns expected at " + parser.getLineNumber() + "(item name and group name).");
                }
                String itemName = fields[0];
                String groupName = fields[1];
                Integer itemIndex = itemNameToRowMapping.get(itemName);
                if (itemIndex == null) continue;
                SortedSet<Integer> itemIndices = moduleItemsMap.get(groupName);
                if (itemIndices == null) {
                    itemIndices = new TreeSet<Integer>();
                    moduleItemsMap.put(groupName, itemIndices);
                }
                itemIndices.add(itemIndex);
            }
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public void save(ModuleMap moduleMap, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Saving modules...", 1);
        try {
            PrintWriter pw = new PrintWriter(this.openWriter());
            String[] itemNames = moduleMap.getItemNames();
            if (itemNames.length > 0) {
                pw.print(itemNames[0]);
                for (int i = 1; i < itemNames.length; ++i) {
                    pw.print("\t\"");
                    pw.print(itemNames[i]);
                    pw.print('\"');
                }
            }
            pw.print('\n');
            String[] moduleNames = moduleMap.getModuleNames();
            int[][] indices = moduleMap.getAllItemIndices();
            int numModules = moduleNames.length;
            for (int i = 0; i < numModules; ++i) {
                pw.print('\"');
                pw.print(moduleNames[i]);
                pw.print('\"');
                for (int index : indices[i]) {
                    pw.print('\t');
                    pw.print(index);
                }
                pw.print('\n');
            }
            pw.close();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            monitor.end();
        }
    }
}

