/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.text.ModuleMapPersistence;
import org.gitools.utils.CSVStrategies;

public class ModuleMapTextIndicesPersistence
extends ModuleMapPersistence<ModuleMap> {
    private static final CSVStrategy csvStrategy = CSVStrategies.TSV;

    @Override
    public ModuleMap read(File file, IProgressMonitor monitor) throws PersistenceException {
        Reader reader;
        monitor.begin("Loading modules...", 1);
        monitor.info("File: " + file.getAbsolutePath());
        try {
            reader = PersistenceUtils.openReader(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening resource: " + file.getName(), e);
        }
        CSVParser parser = new CSVParser(reader, csvStrategy);
        ModuleMap moduleMap = new ModuleMap();
        try {
            this.loadItemNames(moduleMap, monitor, parser);
            this.loadModules(moduleMap, monitor, parser);
            reader.close();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        monitor.end();
        return moduleMap;
    }

    @Override
    public void write(File file, ModuleMap moduleMap, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Saving modules...", moduleMap.getModuleNames().length);
        monitor.info("File: " + file.getAbsolutePath());
        try {
            PrintWriter pw = new PrintWriter(PersistenceUtils.openWriter(file));
            String[] itemNames = moduleMap.getItemNames();
            if (itemNames.length > 0) {
                pw.print('\"');
                pw.print(itemNames[0]);
                pw.print('\"');
                for (int i = 1; i < itemNames.length; ++i) {
                    pw.print("\t\"");
                    pw.print(itemNames[i]);
                    pw.print('\"');
                }
            }
            pw.print('\n');
            String[] moduleNames = moduleMap.getModuleNames();
            int[][] indices = moduleMap.getAllItemIndices();
            int numModules = moduleNames.length;
            for (int i = 0; i < numModules; ++i) {
                pw.print('\"');
                pw.print(moduleNames[i]);
                pw.print('\"');
                for (int index : indices[i]) {
                    pw.print('\t');
                    pw.print(index);
                }
                pw.print('\n');
                monitor.worked(1);
            }
            pw.close();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        finally {
            monitor.end();
        }
    }

    private void loadItemNames(ModuleMap moduleMap, IProgressMonitor monitor, CSVParser parser) throws FileNotFoundException, IOException, DataFormatException {
        monitor.begin("Reading item names ...", 1);
        String[] itemNames = parser.getLine();
        moduleMap.setItemNames(itemNames);
        monitor.info(itemNames.length + " items");
        monitor.end();
    }

    private void loadModules(ModuleMap moduleMap, IProgressMonitor monitor, CSVParser parser) throws NumberFormatException, IOException {
        int i;
        String[] fields;
        monitor.begin("Reading modules ...", 1);
        String[] itemNames = moduleMap.getItemNames();
        BitSet valid = new BitSet(itemNames.length);
        if (this.isItemNamesFilterEnabled()) {
            HashMap<String, Integer> itemIndices = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < itemNames.length; ++i2) {
                itemIndices.put(itemNames[i2], i2);
            }
            for (String name : this.getItemNames()) {
                Integer index = (Integer)itemIndices.get(name);
                if (index == null) continue;
                valid.set(index);
            }
        } else {
            valid.set(0, itemNames.length);
        }
        BitSet used = new BitSet(itemNames.length);
        HashMap mapItemIndices = new HashMap();
        int minSize = this.getMinSize();
        int maxSize = this.getMaxSize();
        while ((fields = parser.getLine()) != null) {
            String moduleName = fields[0];
            HashSet<Integer> items = new HashSet<Integer>();
            for (int j = 1; j < fields.length; ++j) {
                boolean inRange;
                int index = Integer.parseInt(fields[j]);
                boolean bl = inRange = index >= 0 && index < itemNames.length;
                if (!inRange || !valid.get(index)) continue;
                items.add(index);
                used.set(index);
            }
            if (items.size() >= minSize && items.size() <= maxSize) {
                mapItemIndices.put(moduleName, items);
                continue;
            }
            items.clear();
        }
        int lastIndex = 0;
        int[] indexMap = new int[itemNames.length];
        for (i = 0; i < itemNames.length; ++i) {
            if (!used.get(i)) continue;
            indexMap[i] = lastIndex++;
        }
        i = 0;
        String[] finalItemNames = new String[lastIndex];
        for (int j = 0; j < itemNames.length; ++j) {
            if (!used.get(j)) continue;
            finalItemNames[i++] = itemNames[j];
        }
        i = 0;
        String[] moduleNames = new String[mapItemIndices.size()];
        int[][] moduleItemIndices = new int[moduleNames.length][];
        for (Map.Entry entry : mapItemIndices.entrySet()) {
            moduleNames[i] = (String)entry.getKey();
            int[] indices = new int[((Set)entry.getValue()).size()];
            Iterator it = ((Set)entry.getValue()).iterator();
            for (int j = 0; j < indices.length; ++j) {
                indices[j] = indexMap[(Integer)it.next()];
            }
            moduleItemIndices[i] = indices;
            ++i;
        }
        moduleMap.setItemNames(finalItemNames);
        moduleMap.setModuleNames(moduleNames);
        moduleMap.setAllItemIndices(moduleItemIndices);
        monitor.info(moduleNames.length + " modules and " + finalItemNames.length + " items annotated");
        monitor.end();
    }
}

