/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.csv.CSVParser;
import org.gitools.model.ModuleMap;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.text.ModuleMapPersistence;
import org.gitools.utils.CSVStrategies;

public class ModuleMapText2CPersistence
extends ModuleMapPersistence<ModuleMap> {
    @Override
    public ModuleMap read(File file, IProgressMonitor monitor) throws PersistenceException {
        TreeMap<String, Integer> itemNameToRowMapping = new TreeMap<String, Integer>();
        if (this.isItemNamesFilterEnabled()) {
            String[] itemNames = this.getItemNames();
            for (int i = 0; i < itemNames.length; ++i) {
                itemNameToRowMapping.put(itemNames[i], i);
            }
        }
        HashMap<String, Set<Integer>> moduleItemsMap = new HashMap<String, Set<Integer>>();
        try {
            monitor.begin("Reading modules ...", 1);
            Reader reader = PersistenceUtils.openReader(file);
            CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
            this.readModuleMappings(parser, this.isItemNamesFilterEnabled(), itemNameToRowMapping, moduleItemsMap);
            monitor.end();
        }
        catch (Exception ex) {
            throw new PersistenceException(ex);
        }
        monitor.begin("Filtering modules ...", 1);
        int minSize = this.getMinSize();
        int maxSize = this.getMaxSize();
        String[] itemNames = new String[itemNameToRowMapping.size()];
        for (Map.Entry entry : itemNameToRowMapping.entrySet()) {
            itemNames[((Integer)entry.getValue()).intValue()] = (String)entry.getKey();
        }
        BitSet used = new BitSet(itemNames.length);
        int lastIndex = 0;
        int[] indexMap = new int[itemNames.length];
        ArrayList moduleNames = new ArrayList();
        ArrayList<int[]> modulesItemIndices = new ArrayList<int[]>();
        Iterator it = moduleItemsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set indices = (Set)entry.getValue();
            if (indices.size() >= minSize && indices.size() <= maxSize) {
                moduleNames.add(entry.getKey());
                int[] remapedIndices = new int[indices.size()];
                Iterator iit = indices.iterator();
                for (int i = 0; i < indices.size(); ++i) {
                    int index = (Integer)iit.next();
                    if (!used.get(index)) {
                        used.set(index);
                        indexMap[index] = lastIndex++;
                    }
                    remapedIndices[i] = indexMap[index];
                }
                modulesItemIndices.add(remapedIndices);
                continue;
            }
            it.remove();
        }
        String[] finalItemNames = new String[lastIndex];
        for (int i = 0; i < itemNames.length; ++i) {
            if (!used.get(i)) continue;
            finalItemNames[indexMap[i]] = itemNames[i];
        }
        monitor.end();
        ModuleMap mmap = new ModuleMap();
        mmap.setItemNames(finalItemNames);
        mmap.setModuleNames(moduleNames.toArray(new String[moduleNames.size()]));
        mmap.setAllItemIndices((int[][])modulesItemIndices.toArray((T[])new int[modulesItemIndices.size()][]));
        return mmap;
    }

    protected void readModuleMappings(CSVParser parser, boolean filterRows, Map<String, Integer> itemNameToRowMapping, Map<String, Set<Integer>> moduleItemsMap) throws PersistenceException {
        try {
            String[] fields;
            while ((fields = parser.getLine()) != null) {
                if (fields.length < 2) {
                    throw new PersistenceException("At least 2 columns expected at " + parser.getLineNumber() + "(item name and group name).");
                }
                String itemName = fields[0];
                String groupName = fields[1];
                Integer itemIndex = itemNameToRowMapping.get(itemName);
                if (itemIndex == null && !filterRows) {
                    itemIndex = itemNameToRowMapping.size();
                    itemNameToRowMapping.put(itemName, itemIndex);
                }
                if (itemIndex == null) continue;
                Set<Integer> itemIndices = moduleItemsMap.get(groupName);
                if (itemIndices == null) {
                    itemIndices = new TreeSet<Integer>();
                    moduleItemsMap.put(groupName, itemIndices);
                }
                itemIndices.add(itemIndex);
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void write(File file, ModuleMap moduleMap, IProgressMonitor monitor) throws PersistenceException {
        String[] moduleNames = moduleMap.getModuleNames();
        int numModules = moduleNames.length;
        monitor.begin("Saving modules...", numModules);
        try {
            Writer writer = PersistenceUtils.openWriter(file);
            PrintWriter pw = new PrintWriter(writer);
            String[] itemNames = moduleMap.getItemNames();
            int[][] indices = moduleMap.getAllItemIndices();
            for (int i = 0; i < numModules; ++i) {
                for (int index : indices[i]) {
                    pw.print(itemNames[index]);
                    pw.print('\t');
                    pw.print(moduleNames[i]);
                    pw.print('\n');
                }
                monitor.worked(1);
            }
            pw.close();
            monitor.end();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }
}

