/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.zip.DataFormatException;
import org.apache.commons.csv.CSVParser;
import org.gitools.datafilters.DoubleTranslator;
import org.gitools.datafilters.ValueTranslator;
import org.gitools.matrix.model.BaseMatrix;
import org.gitools.model.Artifact;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.text.BaseMatrixPersistence;
import org.gitools.utils.CSVStrategies;

public abstract class MatrixTextPersistence<T extends BaseMatrix>
extends BaseMatrixPersistence<T> {
    public static final String BINARY_VALUES = "binary_values";
    public static final String VALUE_TRANSLATOR = "value_translator";

    protected boolean isBinaryValues() {
        if (this.getProperties().containsKey(BINARY_VALUES)) {
            return (Boolean)this.getProperties().get(BINARY_VALUES);
        }
        return false;
    }

    protected ValueTranslator getValueTranslator() {
        if (this.getProperties().containsKey(VALUE_TRANSLATOR)) {
            return (ValueTranslator)this.getProperties().get(VALUE_TRANSLATOR);
        }
        return new DoubleTranslator();
    }

    protected abstract T createEntity();

    public T read(File file, ValueTranslator filt, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Loading matrix...", 1);
        monitor.info("File: " + file.getAbsolutePath());
        T matrix = this.createEntity();
        this.readMetadata(file, matrix, monitor);
        this.readData(file, matrix, filt, null, null, monitor);
        monitor.end();
        return matrix;
    }

    public void readMetadata(File file, T matrix, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Reading names ...", 1);
        Reader reader = null;
        try {
            reader = PersistenceUtils.openReader(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening file: " + file.getName(), e);
        }
        CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
        try {
            String[] fields;
            String[] header = parser.getLine();
            if (header.length < 2) {
                throw new DataFormatException("At least 2 columns expected.");
            }
            ((Artifact)matrix).setTitle(header[0]);
            int numColumns = header.length - 1;
            String[] columnNames = new String[numColumns];
            System.arraycopy(header, 1, columnNames, 0, numColumns);
            ((BaseMatrix)matrix).setColumns(columnNames);
            String[] populationLabels = this.getPopulationLabels();
            HashSet<String> popLabelsSet = populationLabels != null ? new HashSet<String>(Arrays.asList(populationLabels)) : null;
            ArrayList<String> names = new ArrayList<String>();
            while ((fields = parser.getLine()) != null) {
                if (popLabelsSet != null && !popLabelsSet.contains(fields[0])) continue;
                names.add(fields[0]);
            }
            if (populationLabels != null) {
                HashSet<String> nameSet = new HashSet<String>(names);
                for (String name : populationLabels) {
                    if (nameSet.contains(name)) continue;
                    names.add(name);
                    nameSet.add(name);
                }
            }
            String[] rowNames = names.toArray(new String[names.size()]);
            ((BaseMatrix)matrix).setRows(rowNames);
            reader.close();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        monitor.info(((BaseMatrix)matrix).getColumns().cardinality() + " columns and " + ((BaseMatrix)matrix).getRows().cardinality() + " rows");
        monitor.end();
    }

    public void readData(File file, T matrix, ValueTranslator valueTranslator, int[] columnsOrder, int[] rowsOrder, IProgressMonitor monitor) throws PersistenceException {
        Reader reader;
        monitor.begin("Reading data ...", 1);
        int numColumns = ((BaseMatrix)matrix).getColumns().cardinality();
        int numRows = ((BaseMatrix)matrix).getRows().cardinality();
        String[] columnNames = ((BaseMatrix)matrix).getColumnStrings();
        String[] rowNames = ((BaseMatrix)matrix).getRowStrings();
        String[] finalColumnNames = new String[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            int colidx = columnsOrder != null ? columnsOrder[i] : i;
            finalColumnNames[colidx] = columnNames[i];
        }
        columnNames = finalColumnNames;
        String[] populationLabels = this.getPopulationLabels();
        HashSet<String> popLabelsSet = populationLabels != null ? new HashSet<String>(Arrays.asList(populationLabels)) : null;
        try {
            reader = PersistenceUtils.openReader(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening resource: " + file.getName(), e);
        }
        try {
            int col;
            String[] fields;
            CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
            parser.getLine();
            ((BaseMatrix)matrix).makeCells(numRows, numColumns);
            int row = 0;
            while ((fields = parser.getLine()) != null) {
                int rowidx;
                if (popLabelsSet != null && !popLabelsSet.contains(fields[0])) continue;
                int n = rowidx = rowsOrder != null ? rowsOrder[row] : row;
                if (rowidx >= 0) {
                    int colidx;
                    rowNames[rowidx] = fields[0];
                    for (col = 0; col < numColumns && col < fields.length - 1; ++col) {
                        colidx = columnsOrder != null ? columnsOrder[col] : col;
                        Double value = (Double)valueTranslator.stringToValue(fields[col + 1]);
                        matrix.setCellValue(rowidx, colidx, 0, (Object)value);
                    }
                    while (col < numColumns) {
                        colidx = columnsOrder != null ? columnsOrder[col] : col;
                        matrix.setCellValue(rowidx, colidx, 0, (Object)Double.NaN);
                        ++col;
                    }
                }
                ++row;
            }
            Double backgroundValue = this.getBackgroundValue();
            while (row < numRows) {
                for (col = 0; col < numColumns; ++col) {
                    matrix.setCellValue(row, col, 0, (Object)backgroundValue);
                }
                ++row;
            }
            reader.close();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        monitor.end();
    }

    public void write(File file, T matrix, ValueTranslator valueTranslator, IProgressMonitor monitor) throws PersistenceException {
        Writer writer;
        monitor.begin("Saving matrix...", matrix.getColumnCount());
        monitor.info("File: " + file.getAbsolutePath());
        try {
            writer = PersistenceUtils.openWriter(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening resource: " + file.getName(), e);
        }
        PrintWriter pw = new PrintWriter(writer);
        int numCols = matrix.getColumnCount();
        String[] colNames = ((BaseMatrix)matrix).getColumnStrings();
        pw.print(((Artifact)matrix).getTitle() != null ? ((Artifact)matrix).getTitle() : "");
        for (int i = 0; i < numCols; ++i) {
            String name = i < colNames.length ? colNames[i] : "";
            pw.print('\t');
            pw.print(name);
        }
        pw.print('\n');
        int numRows = matrix.getRowCount();
        String[] rowNames = ((BaseMatrix)matrix).getRowStrings();
        for (int i = 0; i < numRows; ++i) {
            String name = i < rowNames.length ? rowNames[i] : "";
            pw.print(name);
            for (int j = 0; j < numCols; ++j) {
                pw.print('\t');
                pw.print(valueTranslator.valueToString(matrix.getCellValue(i, j, 0)));
            }
            pw.print('\n');
            monitor.worked(1);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new PersistenceException("Error closing file: " + file.getName(), e);
        }
        monitor.end();
    }
}

