/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVParser;
import org.gitools.persistence.AbstractEntityPersistence;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.utils.CSVStrategies;

public class GeneSetPersistence
extends AbstractEntityPersistence<List<String>> {
    @Override
    public List<String> read(File file, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Reading ...", 1);
        monitor.info("File: " + file.getAbsolutePath());
        HashMap<String, Integer> labelMap = new HashMap<String, Integer>();
        Reader reader = null;
        try {
            reader = PersistenceUtils.openReader(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening file: " + file.getName(), e);
        }
        CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
        try {
            String[] fields;
            while ((fields = parser.getLine()) != null) {
                if (fields.length > 1) {
                    throw new PersistenceException("Only one column is allowed at line " + parser.getLineNumber());
                }
                Integer index = (Integer)labelMap.get(fields[0]);
                if (index != null) continue;
                labelMap.put(fields[0], labelMap.size());
            }
            reader.close();
            monitor.info(labelMap.size() + " rows");
            monitor.end();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        ArrayList<String> labels = new ArrayList<String>(labelMap.keySet());
        for (Map.Entry entry : labelMap.entrySet()) {
            labels.set((Integer)entry.getValue(), (String)entry.getKey());
        }
        return labels;
    }

    @Override
    public void write(File file, List<String> entity, IProgressMonitor monitor) throws PersistenceException {
        Writer writer;
        monitor.begin("Saving matrix...", entity.size());
        monitor.info("File: " + file.getAbsolutePath());
        try {
            writer = PersistenceUtils.openWriter(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening resource: " + file.getName(), e);
        }
        PrintWriter pw = new PrintWriter(writer);
        for (String label : entity) {
            pw.println(label);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new PersistenceException("Error closing file: " + file.getName(), e);
        }
        monitor.end();
    }
}

