/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.csv.CSVParser;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.DoubleBinaryMatrix;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.text.BaseMatrixPersistence;
import org.gitools.utils.CSVStrategies;

public class GeneMatrixTransposedPersistence
extends BaseMatrixPersistence<DoubleBinaryMatrix> {
    @Override
    public DoubleBinaryMatrix read(File file, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Reading names ...", 1);
        DoubleBinaryMatrix matrix = new DoubleBinaryMatrix();
        Reader reader = null;
        try {
            reader = PersistenceUtils.openReader(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening file: " + file.getName(), e);
        }
        CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
        try {
            String[] fields;
            ArrayList<String> colNames = new ArrayList<String>();
            ArrayList<int[]> colRowIndices = new ArrayList<int[]>();
            HashMap<String, Integer> rowIndices = new HashMap<String, Integer>();
            while ((fields = parser.getLine()) != null) {
                if (fields.length < 2) {
                    throw new PersistenceException("Invalid row, at least 2 columns required (name and description) at line " + parser.getLineNumber());
                }
                colNames.add(fields[0]);
                int[] rows = new int[fields.length - 2];
                colRowIndices.add(rows);
                for (int i = 2; i < fields.length; ++i) {
                    Integer rowIndex = (Integer)rowIndices.get(fields[i]);
                    if (rowIndex == null) {
                        rowIndex = rowIndices.size();
                        rowIndices.put(fields[i], rowIndex);
                    }
                    rows[i - 2] = rowIndex;
                }
            }
            String[] populationLabels = this.getPopulationLabels();
            if (populationLabels != null) {
                for (String name : populationLabels) {
                    Integer index = (Integer)rowIndices.get(name);
                    if (index != null) continue;
                    rowIndices.put(name, rowIndices.size());
                }
            }
            int numRows = rowIndices.size();
            int numColumns = colNames.size();
            matrix.makeCells(numRows, numColumns);
            for (Map.Entry entry : rowIndices.entrySet()) {
                matrix.setRow((Integer)entry.getValue(), entry.getKey());
            }
            double backgroundValue = this.getBackgroundValue();
            for (int row = 0; row < numRows; ++row) {
                for (int col = 0; col < numColumns; ++col) {
                    matrix.setCellValue(row, col, 0, (Object)backgroundValue);
                }
            }
            int colIndex = 0;
            Iterator colNameIt = colNames.iterator();
            Iterator colRowsIt = colRowIndices.iterator();
            while (colNameIt.hasNext()) {
                int[] rows;
                matrix.setColumn(colIndex, colNameIt.next());
                for (int row : rows = (int[])colRowsIt.next()) {
                    matrix.setCellValue(row, colIndex, 0, (Object)1.0);
                }
                ++colIndex;
            }
            reader.close();
            monitor.info(matrix.getColumnCount() + " columns and " + matrix.getRowCount() + " rows");
            monitor.end();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        return matrix;
    }

    @Override
    public void write(File file, DoubleBinaryMatrix matrix, IProgressMonitor monitor) throws PersistenceException {
        Writer writer;
        monitor.begin("Saving matrix...", matrix.getColumnCount());
        monitor.info("File: " + file.getAbsolutePath());
        try {
            writer = PersistenceUtils.openWriter(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening resource: " + file.getName(), e);
        }
        PrintWriter pw = new PrintWriter(writer);
        int rowCount = matrix.getRowCount();
        for (int ci = 0; ci < matrix.getColumnCount(); ++ci) {
            pw.append(matrix.getColumnLabel(ci));
            pw.append('\t');
            for (int ri = 0; ri < rowCount; ++ri) {
                Double value = MatrixUtils.doubleValue(matrix.getCellValue(ri, ci, 0));
                if (value != 1.0) continue;
                pw.append('\t').append(matrix.getRowLabel(ri));
            }
            pw.println();
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new PersistenceException("Error closing file: " + file.getName(), e);
        }
        monitor.end();
    }
}

