/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence.text;

import cern.colt.matrix.ObjectFactory1D;
import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVParser;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.DoubleBinaryMatrix;
import org.gitools.persistence.PersistenceException;
import org.gitools.persistence.PersistenceUtils;
import org.gitools.persistence.text.BaseMatrixPersistence;
import org.gitools.utils.CSVStrategies;

public class GeneMatrixPersistence
extends BaseMatrixPersistence<DoubleBinaryMatrix> {
    @Override
    public DoubleBinaryMatrix read(File file, IProgressMonitor monitor) throws PersistenceException {
        monitor.begin("Reading ...", 1);
        DoubleBinaryMatrix matrix = new DoubleBinaryMatrix();
        Reader reader = null;
        try {
            reader = PersistenceUtils.openReader(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening file: " + file.getName(), e);
        }
        CSVParser parser = new CSVParser(reader, CSVStrategies.TSV);
        try {
            String[] fields;
            int i;
            String[] columnNames = parser.getLine();
            parser.getLine();
            HashMap<String, Integer> rowIndices = new HashMap<String, Integer>();
            ArrayList indices = new ArrayList(columnNames.length);
            for (i = 0; i < columnNames.length; ++i) {
                indices.add(new HashSet());
            }
            while ((fields = parser.getLine()) != null) {
                if (fields.length > columnNames.length) {
                    throw new PersistenceException("Row with more columns than expected at line " + parser.getLineNumber());
                }
                for (i = 0; i < fields.length; ++i) {
                    String name = fields[i];
                    if (name.isEmpty()) continue;
                    Integer rowIndex = (Integer)rowIndices.get(name);
                    if (rowIndex == null) {
                        rowIndex = rowIndices.size();
                        rowIndices.put(name, rowIndex);
                    }
                    ((Set)indices.get(i)).add(rowIndex);
                }
            }
            String[] populationLabels = this.getPopulationLabels();
            if (populationLabels != null) {
                for (String name : populationLabels) {
                    Integer index = (Integer)rowIndices.get(name);
                    if (index != null) continue;
                    rowIndices.put(name, rowIndices.size());
                }
            }
            int numRows = rowIndices.size();
            matrix.makeCells(numRows, columnNames.length);
            matrix.setRows(ObjectFactory1D.dense.make(numRows));
            for (Map.Entry entry : rowIndices.entrySet()) {
                matrix.setRow((Integer)entry.getValue(), entry.getKey());
            }
            matrix.setColumns(columnNames);
            double backgroundValue = this.getBackgroundValue();
            for (int row = 0; row < numRows; ++row) {
                for (int col = 0; col < columnNames.length; ++col) {
                    matrix.setCellValue(row, col, 0, (Object)backgroundValue);
                }
            }
            for (int col = 0; col < columnNames.length; ++col) {
                Set colIndices = (Set)indices.get(col);
                for (Integer index : colIndices) {
                    matrix.setCellValue((int)index, col, 0, (Object)1.0);
                }
            }
            reader.close();
            monitor.info(matrix.getColumnCount() + " columns and " + matrix.getRowCount() + " rows");
            monitor.end();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        return matrix;
    }

    @Override
    public void write(File file, DoubleBinaryMatrix matrix, IProgressMonitor monitor) throws PersistenceException {
        int col;
        Writer writer;
        monitor.begin("Saving matrix...", matrix.getColumnCount());
        monitor.info("File: " + file.getAbsolutePath());
        try {
            writer = PersistenceUtils.openWriter(file);
        }
        catch (Exception e) {
            throw new PersistenceException("Error opening resource: " + file.getName(), e);
        }
        PrintWriter pw = new PrintWriter(writer);
        int numColumns = matrix.getColumnCount();
        int numRows = matrix.getRowCount();
        pw.append(matrix.getColumnLabel(0));
        for (col = 1; col < matrix.getColumnCount(); ++col) {
            pw.append('\t').append(matrix.getColumnLabel(col));
        }
        pw.println();
        for (col = 1; col < matrix.getColumnCount(); ++col) {
            pw.append('\t');
        }
        pw.println();
        StringBuilder line = new StringBuilder();
        int finishedColumns = 0;
        int[] positions = new int[numColumns];
        while (finishedColumns < numColumns) {
            boolean validLine = false;
            for (int col2 = 0; col2 < numColumns; ++col2) {
                int row;
                if (col2 != 0) {
                    line.append('\t');
                }
                if ((row = positions[col2]) >= numRows) continue;
                double value = MatrixUtils.doubleValue(matrix.getCellValue(row, col2, 0));
                while (value != 1.0 && row < numRows - 1) {
                    value = MatrixUtils.doubleValue(matrix.getCellValue(++row, col2, 0));
                }
                if (value == 1.0) {
                    line.append(matrix.getRowLabel(row));
                    validLine = true;
                }
                positions[col2] = row + 1;
                if (positions[col2] < numRows) continue;
                ++finishedColumns;
            }
            if (validLine) {
                pw.append(line).append('\n');
            }
            line.setLength(0);
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            throw new PersistenceException("Error closing file: " + file.getName(), e);
        }
        monitor.end();
    }
}

