/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence;

import edu.upf.bg.fileutils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Pattern;

public class PersistenceUtils {
    public static Reader openReader(File path) throws IOException {
        return IOUtils.openReader(path);
    }

    public static Writer openWriter(File path) throws IOException {
        return IOUtils.openWriter(path);
    }

    public static Writer openWriter(File path, boolean append) throws IOException {
        return IOUtils.openWriter(path, append);
    }

    public static OutputStream openOutputStream(File path) throws IOException {
        return IOUtils.openOutputStream(path);
    }

    public static OutputStream openOutputStream(File path, boolean append) throws IOException {
        return IOUtils.openOutputStream(path, append);
    }

    public static String getRelativePath(String basePath, String targetPath) {
        String pathSeparator = File.separator;
        boolean isDir = false;
        File f = new File(targetPath);
        isDir = f.isDirectory();
        String[] base = basePath.split(Pattern.quote(pathSeparator), -1);
        String[] target = targetPath.split(Pattern.quote(pathSeparator), 0);
        String common = "";
        int commonIndex = 0;
        for (int i = 0; i < target.length && i < base.length && target[i].equals(base[i]); ++i) {
            common = common + target[i] + pathSeparator;
            ++commonIndex;
        }
        if (commonIndex == 0) {
            return targetPath;
        }
        String relative = "";
        if (base.length != commonIndex) {
            int numDirsUp = base.length - commonIndex;
            for (int i = 1; i <= numDirsUp; ++i) {
                relative = relative + ".." + pathSeparator;
            }
        }
        if (targetPath.length() > common.length()) {
            relative = relative + targetPath.substring(common.length());
        }
        return relative;
    }

    public static String getBaseName(String path) {
        int sep = path.lastIndexOf(File.separatorChar);
        return path.substring(sep + 1);
    }

    public static String getFileName(String path) {
        int dot = path.lastIndexOf(46);
        if (dot > 0 && path.substring(dot).equalsIgnoreCase(".gz")) {
            dot = path.substring(0, dot - 1).lastIndexOf(46);
        }
        int sep = path.lastIndexOf(File.separatorChar);
        return dot != -1 ? path.substring(sep + 1, dot) : path.substring(sep + 1);
    }

    public static String getExtension(String path) {
        String[] e;
        String ext;
        int dot = path.lastIndexOf(46);
        String string = ext = dot != -1 ? path.substring(dot + 1) : "";
        if (ext.equalsIgnoreCase("gz") && (e = path.split("[.]")).length >= 2) {
            ext = e[e.length - 2] + "." + e[e.length - 1];
        }
        return ext;
    }

    public static boolean isAbsolute(String path) {
        return path.matches("^(\\/.*|[a-zA-Z]\\:\\\\)");
    }
}

