/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence;

import edu.upf.bg.progressmonitor.IProgressMonitor;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gitools.persistence.IEntityPersistence;
import org.gitools.persistence.PersistenceException;

public class PersistenceManager
implements Serializable {
    private static final long serialVersionUID = -1442103565401901838L;
    private static PersistenceManager defaultManager;
    private final Map<String, Class<? extends IEntityPersistence<?>>> mimeToPClass = new HashMap();
    private final Map<String, String> mimeToExt = new HashMap<String, String>();
    private final Map<String, String> extToMime = new HashMap<String, String>();
    private final Map<Class<?>, String> eclassToMime = new HashMap();
    private final Map<FileRef, Object> entityCache = new HashMap<FileRef, Object>();
    private final Map<Object, FileRef> entityFileRefMap = new HashMap<Object, FileRef>();

    public static PersistenceManager getDefault() {
        if (defaultManager == null) {
            defaultManager = new PersistenceManager();
        }
        return defaultManager;
    }

    public void registerFormat(String mime, String extension, Class<? extends IEntityPersistence<?>> pclass) {
        this.registerFormat(mime, extension, null, pclass);
    }

    public void registerFormat(String mime, String extension, Class<?> eclass, Class<? extends IEntityPersistence<?>> pclass) {
        this.mimeToPClass.put(mime, pclass);
        this.mimeToExt.put(mime, extension);
        if (eclass != null) {
            this.eclassToMime.put(eclass, mime);
        }
        this.registerExtension(extension, mime);
    }

    public void registerExtension(String extension, String mime) {
        this.extToMime.put(extension, mime);
        this.extToMime.put(extension + ".gz", mime);
    }

    public String getMimeFromFile(String fileName) {
        for (Map.Entry<String, String> entry : this.extToMime.entrySet()) {
            if (!fileName.endsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getMimeFromEntity(Class<?> entityClass) {
        return this.eclassToMime.get(entityClass);
    }

    public String getExtensionFromMime(String mime) {
        return this.mimeToExt.get(mime);
    }

    public String getExtensionFromEntity(Class<?> entityClass) {
        return this.getExtensionFromMime(this.getMimeFromEntity(entityClass));
    }

    public <T> IEntityPersistence<T> createEntityPersistence(String mimeType, Properties properties) {
        Class<IEntityPersistence<?>> persistenceClass = this.mimeToPClass.get(mimeType);
        try {
            Constructor<IEntityPersistence<?>> c = persistenceClass.getConstructor(new Class[0]);
            IEntityPersistence<?> entityPersistence = c.newInstance(new Object[0]);
            entityPersistence.setPersistenceManager(this);
            entityPersistence.setProperties(properties);
            return entityPersistence;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object load(File file, IProgressMonitor monitor) throws PersistenceException {
        return this.load(file, null, new Properties(), monitor);
    }

    public Object load(File file, String mimeType, IProgressMonitor monitor) throws PersistenceException {
        return this.load(file, mimeType, new Properties(), monitor);
    }

    public Object load(File file, Properties properties, IProgressMonitor monitor) throws PersistenceException {
        return this.load(file, null, properties, monitor);
    }

    public Object load(File file, String mimeType, Properties properties, IProgressMonitor monitor) throws PersistenceException {
        FileRef fileRef;
        if (mimeType == null) {
            mimeType = this.getMimeFromFile(file.getName());
        }
        if (this.entityCache.containsKey(fileRef = new FileRef(file, mimeType))) {
            return this.entityCache.get(fileRef);
        }
        IEntityPersistence entityPersistence = this.createEntityPersistence(mimeType, properties);
        Object entity = entityPersistence.read(file, monitor);
        return entity;
    }

    public void store(File file, Object entity, IProgressMonitor monitor) throws PersistenceException {
        String mimeType = this.getMimeFromEntity(entity.getClass());
        this.store(file, mimeType, entity, new Properties(), monitor);
    }

    public void store(File file, String mimeType, Object entity, IProgressMonitor monitor) throws PersistenceException {
        this.store(file, mimeType, entity, new Properties(), monitor);
    }

    public void store(File file, String mimeType, Object entity, Properties properties, IProgressMonitor monitor) throws PersistenceException {
        IEntityPersistence<Object> entityPersistence = this.createEntityPersistence(mimeType, properties);
        entityPersistence.write(file, entity, monitor);
        FileRef fileRef = new FileRef(file, mimeType);
    }

    public void clearEntityCache() {
        this.entityCache.clear();
        this.entityFileRefMap.clear();
    }

    public void clearEntityCache(Object entity) {
        FileRef fileRef = this.entityFileRefMap.get(entity);
        if (fileRef != null) {
            this.entityFileRefMap.remove(entity);
            this.entityCache.remove(fileRef);
        }
    }

    public void clearEntityCache(File file, String mimeType) {
        FileRef fileRef = new FileRef(file, mimeType);
        if (this.entityCache.containsKey(fileRef)) {
            Object entity = this.entityCache.get(fileRef);
            this.entityFileRefMap.remove(entity);
            this.entityCache.remove(fileRef);
        }
    }

    @Deprecated
    public File getEntityFile(Object entity) {
        return this.entityFileRefMap.get(entity).getFile();
    }

    @Deprecated
    public String getEntityMime(Object entity) {
        return this.entityFileRefMap.get(entity).getMime();
    }

    public FileRef getEntityFileRef(Object entity) {
        return this.entityFileRefMap.get(entity);
    }

    public static class FileRef {
        private File file;
        private String mime;

        public FileRef(File file, String mime) {
            this.file = file;
            this.mime = mime;
        }

        public File getFile() {
            return this.file;
        }

        public String getMime() {
            return this.mime;
        }

        public int hashCode() {
            int code = this.file.hashCode();
            code = 37 * code + (int)this.file.lastModified();
            code = 37 * code + this.mime.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FileRef)) {
                return false;
            }
            FileRef f = (FileRef)obj;
            return this.file.hashCode() == f.file.hashCode() && this.file.lastModified() == f.file.lastModified() && (this.mime == null && f.mime == null || this.mime != null && this.mime.equals(f.mime));
        }
    }
}

