/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.persistence;

public class FileFormat {
    private String title;
    private String extension;
    private String mime;
    private boolean titleWithExtension;
    private boolean allowGzExtension;

    public FileFormat(String title, String extension) {
        this(title, extension, null);
    }

    public FileFormat(String title, String extension, String mime) {
        this(title, extension, mime, true, true);
    }

    public FileFormat(String title, String extension, String mime, boolean titleWithExtension, boolean allowGzExtension) {
        this.title = title;
        this.extension = extension;
        this.mime = mime;
        this.titleWithExtension = titleWithExtension;
        this.allowGzExtension = allowGzExtension;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleWithExtension() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.title).append(" (").append(this.extension);
        if (this.allowGzExtension) {
            sb.append(", ").append(this.extension).append(".gz");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMime() {
        return this.mime;
    }

    public boolean checkExtension(String fileName) {
        String ext;
        return (fileName = fileName.toLowerCase()).endsWith(ext = this.extension.toLowerCase()) || this.allowGzExtension && fileName.endsWith(ext + ".gz");
    }

    public String toString() {
        return this.titleWithExtension ? this.getTitleWithExtension() : this.getTitle();
    }
}

