/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.newick;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gitools.newick.NewickNode;
import org.gitools.newick.NewickParserException;
import org.gitools.newick.NewickTree;

public class NewickParser<VT> {
    private Reader reader;
    private StringBuilder sb;
    private int bufferedChar;
    private int lastRow;
    private int lastCol;
    private int row;
    private int col;

    public NewickParser(String string) {
        this(new StringReader(string));
    }

    public NewickParser(Reader reader) {
        this.reader = reader;
        this.sb = new StringBuilder();
        this.bufferedChar = -1;
        this.col = 0;
        this.row = 0;
        this.lastCol = 0;
        this.lastRow = 0;
    }

    public static void main(String[] args) {
        try {
            NewickParser p = new NewickParser(" ( ( ), (1,2, )B:0.2 ,(:0.4,E):3)A:0.01;");
            NewickTree t = p.parse();
            System.out.println(t);
            System.out.println(t.getDepth());
            for (NewickNode n : t.getRoot().getLeaves()) {
                System.out.println(n);
            }
        }
        catch (NewickParserException ex) {
            Logger.getLogger(NewickParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void close() throws NewickParserException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new NewickParserException(e);
        }
    }

    public NewickTree<VT> parse() throws NewickParserException {
        Token token = null;
        ParserState state = ParserState.TREE_START;
        HashSet<String> names = new HashSet<String>();
        NewickTree tree = null;
        NewickNode node = null;
        NewickNode root = null;
        int level = 0;
        Stack<NewickNode> nodeStack = new Stack<NewickNode>();
        while (state != ParserState.EOF) {
            block0 : switch (state) {
                case TREE_START: {
                    tree = new NewickTree();
                    root = null;
                    node = null;
                    level = 0;
                    nodeStack.clear();
                    token = this.nextTokenNoSpace();
                    switch (token.getType()) {
                        case PAR_OPEN: {
                            state = ParserState.BRANCH_START;
                            break block0;
                        }
                        case COLON_COMMA: {
                            state = ParserState.TREE_END;
                            break block0;
                        }
                    }
                    this.exception("Unexpected token: " + token);
                    break;
                }
                case BRANCH_START: {
                    if (root != null) {
                        nodeStack.push(root);
                    }
                    ++level;
                    root = new NewickNode();
                    node = new NewickNode();
                    root.addChild(node);
                    token = this.nextTokenNoSpace();
                    switch (token.getType()) {
                        case PAR_OPEN: {
                            state = ParserState.BRANCH_START;
                            break block0;
                        }
                        case COMMA: {
                            state = ParserState.BRANCH_ADD;
                            break block0;
                        }
                        case PAR_CLOSE: {
                            state = ParserState.BRANCH_CLOSE;
                            break block0;
                        }
                        case NAME: 
                        case NUMBER: 
                        case TWO_COLON: {
                            state = ParserState.BRANCH_LEAF;
                            break block0;
                        }
                    }
                    this.exception("Unexpected token: " + token);
                    break;
                }
                case BRANCH_ADD: {
                    node = new NewickNode();
                    root.addChild(node);
                    token = this.nextTokenNoSpace();
                    switch (token.getType()) {
                        case PAR_OPEN: {
                            state = ParserState.BRANCH_START;
                            break block0;
                        }
                        case COMMA: {
                            state = ParserState.BRANCH_ADD;
                            break block0;
                        }
                        case PAR_CLOSE: {
                            state = ParserState.BRANCH_CLOSE;
                            break block0;
                        }
                        case NAME: 
                        case NUMBER: 
                        case TWO_COLON: {
                            state = ParserState.BRANCH_LEAF;
                            break block0;
                        }
                    }
                    this.exception("Unexpected token: " + token);
                    break;
                }
                case BRANCH_LEAF: {
                    token = this.parseNodeName(node, token, names);
                    switch (token.getType()) {
                        case COMMA: {
                            state = ParserState.BRANCH_ADD;
                            break block0;
                        }
                        case PAR_CLOSE: {
                            state = ParserState.BRANCH_CLOSE;
                            break block0;
                        }
                    }
                    this.exception("Unexpected token: " + token);
                    break;
                }
                case BRANCH_CLOSE: {
                    if (--level < 0) {
                        this.exception("Unexpected branch closing");
                    }
                    if ((token = this.nextToken()).getType() == TokenType.NAME || token.getType() == TokenType.TWO_COLON) {
                        token = this.parseNodeName(root, token, names);
                    }
                    if (!nodeStack.isEmpty()) {
                        node = root;
                        root = (NewickNode)nodeStack.pop();
                        root.setChild(root.getChildren().size() - 1, node);
                    }
                    switch (token.getType()) {
                        case COMMA: {
                            state = ParserState.BRANCH_ADD;
                            break block0;
                        }
                        case PAR_CLOSE: {
                            state = ParserState.BRANCH_CLOSE;
                            break block0;
                        }
                        case COLON_COMMA: {
                            state = ParserState.TREE_END;
                            break block0;
                        }
                    }
                    this.exception("Unexpected token: " + token);
                    break;
                }
                case TREE_END: {
                    if (level != 0) {
                        this.exception("Unexpected end");
                    }
                    tree.setRoot(root);
                    token = this.nextTokenNoSpace();
                    switch (token.getType()) {
                        case END_OF_STREAM: {
                            state = ParserState.EOF;
                            break block0;
                        }
                    }
                    this.exception("End of stream expected but found " + token);
                }
            }
        }
        return tree;
    }

    private Token parseNodeName(NewickNode node, Token token, Set<String> names) throws NewickParserException {
        if (token.getType() == TokenType.NAME || token.getType() == TokenType.NUMBER) {
            if (names.contains(token.getText())) {
                this.exception("Node name already defined");
            }
            node.setName(token.getText());
            names.add(token.getText());
            token = this.nextToken();
        }
        if (token.getType() == TokenType.TWO_COLON) {
            token = this.nextToken();
            if (token.getType() != TokenType.NUMBER) {
                this.exception("Number expected but found " + token);
            }
            node.setValue(Double.parseDouble(token.getText()));
            token = this.nextTokenNoSpace();
        }
        return token;
    }

    private void exception(String msg) throws NewickParserException {
        throw new NewickParserException("Line " + this.lastRow + " column " + this.lastCol + " -> " + msg);
    }

    private Token nextTokenNoSpace() throws NewickParserException {
        Token token = this.nextToken();
        while (token.getType() == TokenType.SPACE) {
            token = this.nextToken();
        }
        return token;
    }

    private Token nextToken() throws NewickParserException {
        this.sb.setLength(0);
        int state = 83;
        boolean done = false;
        try {
            block16: while (!done) {
                switch (state) {
                    case 83: {
                        int ch = this.nextChar();
                        if (ch == -1) {
                            return new Token(TokenType.END_OF_STREAM, null);
                        }
                        if (this.isWhitespace((char)ch)) {
                            return new Token(TokenType.SPACE, "" + (char)ch);
                        }
                        if (ch == 45) {
                            this.sb.append((char)ch);
                            state = 90;
                            continue block16;
                        }
                        if (Character.isDigit((char)ch)) {
                            this.sb.append((char)ch);
                            state = 73;
                            continue block16;
                        }
                        if (this.isNameChar(ch)) {
                            this.sb.append((char)ch);
                            state = 78;
                            continue block16;
                        }
                        switch (ch) {
                            case 40: {
                                return new Token(TokenType.PAR_OPEN, "" + (char)ch);
                            }
                            case 41: {
                                return new Token(TokenType.PAR_CLOSE, "" + (char)ch);
                            }
                            case 44: {
                                return new Token(TokenType.COMMA, "" + (char)ch);
                            }
                            case 58: {
                                return new Token(TokenType.TWO_COLON, "" + (char)ch);
                            }
                            case 59: {
                                return new Token(TokenType.COLON_COMMA, "" + (char)ch);
                            }
                        }
                        this.exception("Unexpected character: " + (char)ch);
                        continue block16;
                    }
                    case 90: {
                        int ch = this.nextChar();
                        if (Character.isDigit((char)ch)) {
                            this.sb.append((char)ch);
                            state = 73;
                            continue block16;
                        }
                        if (this.isNameChar(ch)) {
                            this.sb.append((char)ch);
                            state = 78;
                            continue block16;
                        }
                        this.bufferedChar = ch;
                        return new Token(TokenType.NAME, this.sb.toString());
                    }
                    case 73: {
                        int ch = this.nextChar();
                        while (ch != -1 && Character.isDigit((char)ch)) {
                            this.sb.append((char)ch);
                            ch = this.nextChar();
                        }
                        if (ch == 46) {
                            this.sb.append((char)ch);
                            state = 70;
                            continue block16;
                        }
                        if (this.isNameChar(ch)) {
                            this.sb.append((char)ch);
                            state = 78;
                            continue block16;
                        }
                        this.bufferedChar = ch;
                        return new Token(TokenType.NUMBER, this.sb.toString());
                    }
                    case 70: {
                        int ch = this.nextChar();
                        while (ch != -1 && Character.isDigit((char)ch)) {
                            this.sb.append((char)ch);
                            ch = this.nextChar();
                        }
                        if (this.isNameChar(ch)) {
                            this.sb.append((char)ch);
                            state = 78;
                            continue block16;
                        }
                        this.bufferedChar = ch;
                        return new Token(TokenType.NUMBER, this.sb.toString());
                    }
                    case 78: {
                        int ch = this.nextChar();
                        while (ch != -1 && this.isNameChar((char)ch)) {
                            this.sb.append((char)ch);
                            ch = this.nextChar();
                        }
                        this.bufferedChar = ch;
                        return new Token(TokenType.NAME, this.sb.toString());
                    }
                }
                throw new NewickParserException("Internal error: Unknown tokenizer state: " + (char)state);
            }
        }
        catch (Exception e) {
            throw new NewickParserException(e);
        }
        throw new NewickParserException("Unexpected tokenizer end");
    }

    private int nextChar() throws IOException {
        int ch;
        block1: {
            this.lastRow = this.row++;
            this.lastCol = this.col++;
            if (this.bufferedChar != -1) {
                int bufChar = this.bufferedChar;
                this.bufferedChar = -1;
                return bufChar;
            }
            ch = this.reader.read();
            if (ch != 10) break block1;
            this.col = 0;
        }
        return ch;
    }

    private boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    private boolean isSpecialChar(int ch) {
        return ch == 40 || ch == 41 || ch == 44 || ch == 58 || ch == 59;
    }

    private boolean isNameChar(int ch) {
        return ch != -1 && !this.isSpecialChar(ch) && !this.isWhitespace((char)ch);
    }

    private static enum ParserState {
        TREE_START,
        BRANCH_START,
        BRANCH_ADD,
        BRANCH_CLOSE,
        BRANCH_LEAF,
        LEAF,
        TREE_END,
        EOF;

    }

    private static class Token {
        private TokenType type;
        private String text;

        public Token(TokenType type, String text) {
            this.type = type;
            this.text = text;
        }

        public TokenType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            if (this.text != null) {
                return this.type.toString() + " " + this.text;
            }
            return this.type.toString();
        }
    }

    private static enum TokenType {
        SPACE,
        NAME,
        NUMBER,
        PAR_OPEN,
        PAR_CLOSE,
        COMMA,
        TWO_COLON,
        COLON_COMMA,
        UNKNOWN,
        END_OF_STREAM;

    }
}

