/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.newick;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gitools.newick.ReverseListIterator;

public class NewickNode<VT> {
    private String name;
    private VT value;
    private List<NewickNode> children;

    public NewickNode() {
        this(null, null);
    }

    public NewickNode(String name, VT value) {
        this.name = name;
        this.value = value;
        this.children = new ArrayList<NewickNode>(2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VT getValue() {
        return this.value;
    }

    public void setValue(VT value) {
        this.value = value;
    }

    public NewickNode getChild(int index) {
        return this.children.get(index);
    }

    public void setChild(int index, NewickNode node) {
        this.children.set(index, node);
    }

    public List<NewickNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(NewickNode node) {
        this.children.add(node);
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public int getMaxDepth() {
        return this.getMaxDepth(0);
    }

    protected int getMaxDepth(int depth) {
        int res = 0;
        if (this.isLeaf()) {
            return depth + 1;
        }
        for (NewickNode child : this.children) {
            int childDepth = child.getMaxDepth(depth + 1);
            if (childDepth <= res) continue;
            res = childDepth;
        }
        return res;
    }

    protected void leaves(List<NewickNode> leaves, int maxLevel, Order order) {
        if (this.children.isEmpty() || maxLevel == 0) {
            leaves.add(this);
        } else if (maxLevel > 0) {
            Iterable<NewickNode> iterable = null;
            switch (order) {
                case PRE_ORDER: {
                    iterable = this.children;
                    break;
                }
                case POST_ORDER: {
                    iterable = new ReverseListIterator<NewickNode>(this.children);
                }
            }
            for (NewickNode node : iterable) {
                node.leaves(leaves, maxLevel - 1, order);
            }
        }
    }

    public List<NewickNode> getLeaves(int maxLevel, Order order) {
        ArrayList<NewickNode> leaves = new ArrayList<NewickNode>();
        this.leaves(leaves, maxLevel, order);
        return leaves;
    }

    public List<NewickNode> getLeaves(int maxLevel) {
        return this.getLeaves(maxLevel, Order.PRE_ORDER);
    }

    public List<NewickNode> getLeaves() {
        return this.getLeaves(Integer.MAX_VALUE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.children.isEmpty()) {
            sb.append('(').append(this.children.get(0));
            for (int i = 1; i < this.children.size(); ++i) {
                sb.append(',').append(this.children.get(i));
            }
            sb.append(')');
        }
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.value != null) {
            sb.append(":").append(this.value);
        }
        return sb.toString();
    }

    public static enum Order {
        PRE_ORDER,
        POST_ORDER;

    }
}

