/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model.decorator.impl;

import cern.jet.stat.Probability;
import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.impl.ZScoreColorScale;
import edu.upf.bg.colorscale.util.ColorConstants;
import edu.upf.bg.formatter.GenericFormatter;
import java.awt.Color;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecoration;
import org.gitools.model.decorator.ElementDecorator;

public class ZScoreElementDecorator
extends ElementDecorator {
    private static final long serialVersionUID = -7623938918947195891L;
    private int valueIndex = this.getPropertyIndex(new String[]{"z-score"});
    private int correctedValueIndex = this.getPropertyIndex(new String[]{"corrected-two-tail-p-value", "corrected-p-value"});
    private boolean useCorrection = false;
    private double significanceLevel = 0.05;
    private ZScoreColorScale scale = new ZScoreColorScale();
    private static final GenericFormatter fmt = new GenericFormatter("<");

    public ZScoreElementDecorator() {
    }

    public ZScoreElementDecorator(IElementAdapter adapter) {
        super(adapter);
    }

    @Override
    public final int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void setValueIndex(int valueIndex) {
        int old = this.valueIndex;
        this.valueIndex = valueIndex;
        this.firePropertyChange("propertyChanged", old, valueIndex);
    }

    public int getCorrectedValueIndex() {
        return this.correctedValueIndex;
    }

    public void setCorrectedValueIndex(int correctionValueIndex) {
        int old = this.correctedValueIndex;
        this.correctedValueIndex = correctionValueIndex;
        this.firePropertyChange("propertyChanged", old, correctionValueIndex);
    }

    public final boolean getUseCorrection() {
        return this.useCorrection;
    }

    public final void setUseCorrection(boolean useCorrection) {
        boolean old = this.useCorrection;
        this.useCorrection = useCorrection;
        this.firePropertyChange("propertyChanged", old, useCorrection);
    }

    public double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public void setSignificanceLevel(double sigLevel) {
        double old = this.significanceLevel;
        this.significanceLevel = sigLevel;
        this.setSigHalfAmplitude(this.calculateSigHalfAmplitudeFromSigLevel(sigLevel));
        this.firePropertyChange("propertyChanged", old, sigLevel);
    }

    private double calculateSigHalfAmplitudeFromSigLevel(double sigLevel) {
        double v = Probability.normalInverse((double)(sigLevel / 2.0));
        return Math.abs(v);
    }

    public final double getSigHalfAmplitude() {
        return this.scale.getSigHalfAmplitude();
    }

    public final void setSigHalfAmplitude(double sigHalfAmplitude) {
        double old = this.scale.getSigHalfAmplitude();
        this.scale.setSigHalfAmplitude(sigHalfAmplitude);
        this.firePropertyChange("propertyChanged", old, sigHalfAmplitude);
    }

    public final ZScoreColorScale getZScoreScale() {
        return this.scale;
    }

    public final void setScale(ZScoreColorScale scale) {
        ZScoreColorScale old = this.scale;
        this.scale = scale;
        this.firePropertyChange("propertyChanged", old, scale);
    }

    public Color getLeftMinColor() {
        return this.scale.getLeftMinColor();
    }

    public void setLeftMinColor(Color color) {
        Color old = this.scale.getLeftMinColor();
        this.scale.setLeftMinColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getLeftMaxColor() {
        return this.scale.getLeftMaxColor();
    }

    public void setLeftMaxColor(Color color) {
        Color old = this.scale.getLeftMaxColor();
        this.scale.setLeftMaxColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getRightMinColor() {
        return this.scale.getRightMinColor();
    }

    public void setRightMinColor(Color color) {
        Color old = this.scale.getRightMinColor();
        this.scale.setRightMinColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getRightMaxColor() {
        return this.scale.getRightMaxColor();
    }

    public void setRightMaxColor(Color color) {
        Color old = this.scale.getRightMaxColor();
        this.scale.setRightMaxColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getNonSignificantColor() {
        return this.scale.getNonSignificantColor();
    }

    public void setNonSignificantColor(Color color) {
        Color old = this.scale.getNonSignificantColor();
        this.scale.setNonSignificantColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getEmptyColor() {
        return this.scale.getEmptyColor();
    }

    public void setEmptyColor(Color color) {
        Color old = this.scale.getEmptyColor();
        this.scale.setEmptyColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    @Override
    public void decorate(ElementDecoration decoration, Object element) {
        decoration.reset();
        Double value = element != null ? this.adapter.getValue(element, this.valueIndex) : Double.valueOf(Double.NaN);
        double v = MatrixUtils.doubleValue(value);
        if (element == null || Double.isNaN(v)) {
            decoration.setBgColor(this.scale.getEmptyColor());
            decoration.setToolTip("Empty cell");
            return;
        }
        boolean useScale = true;
        if (this.useCorrection) {
            Double corrValue = this.correctedValueIndex >= 0 ? this.adapter.getValue(element, this.correctedValueIndex) : Double.valueOf(0.0);
            double cv = MatrixUtils.doubleValue(corrValue);
            useScale = cv <= this.significanceLevel;
        }
        Color color = useScale ? this.scale.valueColor(v) : ColorConstants.nonSignificantColor;
        decoration.setBgColor(color);
        decoration.setToolTip(fmt.pvalue(v));
    }

    @Override
    public IColorScale getScale() {
        return this.scale;
    }
}

