/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model.decorator.impl;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.impl.PValueColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import java.awt.Color;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecoration;
import org.gitools.model.decorator.ElementDecorator;

public class PValueElementDecorator
extends ElementDecorator {
    private static final long serialVersionUID = -1215192981017862718L;
    private int valueIndex = this.getPropertyIndex(new String[]{"right-p-value", "p-value"});
    private int correctedValueIndex = this.getPropertyIndex(new String[]{"corrected-right-p-value", "corrected-p-value"});
    private boolean useCorrection = false;
    private double significanceLevel = 0.05;
    private PValueColorScale scale = new PValueColorScale();
    private static final GenericFormatter fmt = new GenericFormatter("<");

    public PValueElementDecorator() {
    }

    public PValueElementDecorator(IElementAdapter adapter) {
        super(adapter);
    }

    @Override
    public final int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public final void setValueIndex(int valueIndex) {
        int old = this.valueIndex;
        this.valueIndex = valueIndex;
        this.firePropertyChange("propertyChanged", old, valueIndex);
    }

    public final int getCorrectedValueIndex() {
        return this.correctedValueIndex;
    }

    public final void setCorrectedValueIndex(int correctedValueIndex) {
        int old = this.correctedValueIndex;
        this.correctedValueIndex = correctedValueIndex;
        this.firePropertyChange("propertyChanged", old, correctedValueIndex);
    }

    public final boolean getUseCorrection() {
        return this.useCorrection;
    }

    public final void setUseCorrection(boolean useCorrection) {
        boolean old = this.useCorrection;
        this.useCorrection = useCorrection;
        this.firePropertyChange("propertyChanged", old, useCorrection);
    }

    public final double getSignificanceLevel() {
        return this.significanceLevel;
    }

    public final void setSignificanceLevel(double significanceLevel) {
        double old = this.significanceLevel;
        this.significanceLevel = significanceLevel;
        this.scale.setSignificanceLevel(significanceLevel);
        this.firePropertyChange("propertyChanged", old, significanceLevel);
    }

    public final PValueColorScale getPValueScale() {
        return this.scale;
    }

    public Color getMinColor() {
        return this.scale.getMinColor();
    }

    public void setMinColor(Color color) {
        Color old = this.scale.getMinColor();
        this.scale.setMinColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getMaxColor() {
        return this.scale.getMaxColor();
    }

    public void setMaxColor(Color color) {
        Color old = this.scale.getMaxColor();
        this.scale.setMaxColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getNonSignificantColor() {
        return this.scale.getNonSignificantColor();
    }

    public void setNonSignificantColor(Color color) {
        Color old = this.scale.getNonSignificantColor();
        this.scale.setNonSignificantColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    public Color getEmptyColor() {
        return this.scale.getEmptyColor();
    }

    public void setEmptyColor(Color color) {
        Color old = this.scale.getEmptyColor();
        this.scale.setEmptyColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    @Override
    public void decorate(ElementDecoration decoration, Object element) {
        boolean isSig;
        decoration.reset();
        Double value = element != null ? this.adapter.getValue(element, this.valueIndex) : Double.valueOf(Double.NaN);
        double v = MatrixUtils.doubleValue(value);
        if (element == null || Double.isNaN(v)) {
            decoration.setBgColor(this.scale.getEmptyColor());
            decoration.setToolTip("Empty cell");
            return;
        }
        boolean bl = isSig = v <= this.significanceLevel;
        if (this.useCorrection) {
            Double corrValue = this.correctedValueIndex >= 0 ? this.adapter.getValue(element, this.correctedValueIndex) : Double.valueOf(0.0);
            double cv = MatrixUtils.doubleValue(corrValue);
            isSig = cv <= this.significanceLevel;
        }
        Color color = isSig ? this.scale.valueColor(v) : this.scale.getNonSignificantColor();
        decoration.setBgColor(color);
        decoration.setToolTip(fmt.pvalue(v));
    }

    @Override
    public IColorScale getScale() {
        return this.scale;
    }
}

