/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model.decorator.impl;

import edu.upf.bg.colorscale.IColorScale;
import edu.upf.bg.colorscale.impl.LinearTwoSidedColorScale;
import edu.upf.bg.formatter.GenericFormatter;
import java.awt.Color;
import org.gitools.matrix.MatrixUtils;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecoration;
import org.gitools.model.decorator.ElementDecorator;

public class LinearTwoSidedElementDecorator
extends ElementDecorator {
    private static final long serialVersionUID = -181427286948958314L;
    private int valueIndex = this.getPropertyIndex(new String[]{"value", "log2ratio", "score"});
    private LinearTwoSidedColorScale scale;
    private static final GenericFormatter fmt = new GenericFormatter("<");

    public LinearTwoSidedElementDecorator() {
        this(null, new LinearTwoSidedColorScale());
    }

    public LinearTwoSidedElementDecorator(IElementAdapter adapter) {
        this(adapter, new LinearTwoSidedColorScale());
    }

    public LinearTwoSidedElementDecorator(IElementAdapter adapter, LinearTwoSidedColorScale scale) {
        super(adapter);
        this.scale = scale;
    }

    @Override
    public final int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public final void setValueIndex(int valueIndex) {
        int old = this.valueIndex;
        this.valueIndex = valueIndex;
        this.firePropertyChange("propertyChanged", old, valueIndex);
    }

    public final double getMinValue() {
        return this.scale.getMin().getValue();
    }

    public final void setMinValue(double minValue) {
        double old = this.scale.getMin().getValue();
        this.scale.getMin().setValue(minValue);
        this.firePropertyChange("propertyChanged", old, minValue);
    }

    public final double getMidValue() {
        return this.scale.getMid().getValue();
    }

    public final void setMidValue(double midValue) {
        double old = this.scale.getMid().getValue();
        this.scale.getMid().setValue(midValue);
        this.firePropertyChange("propertyChanged", old, midValue);
    }

    public final double getMaxValue() {
        return this.scale.getMax().getValue();
    }

    public final void setMaxValue(double maxValue) {
        double old = this.scale.getMax().getValue();
        this.scale.getMax().setValue(maxValue);
        this.firePropertyChange("propertyChanged", old, maxValue);
    }

    public final Color getMinColor() {
        return this.scale.getMin().getColor();
    }

    public final void setMinColor(Color minColor) {
        Color old = this.scale.getMin().getColor();
        this.scale.getMin().setColor(minColor);
        this.firePropertyChange("propertyChanged", old, minColor);
    }

    public final Color getMidColor() {
        return this.scale.getMid().getColor();
    }

    public final void setMidColor(Color midColor) {
        Color old = this.scale.getMid().getColor();
        this.scale.getMid().setColor(midColor);
        this.firePropertyChange("propertyChanged", old, midColor);
    }

    public final Color getMaxColor() {
        return this.scale.getMax().getColor();
    }

    public final void setMaxColor(Color maxColor) {
        Color old = this.scale.getMax().getColor();
        this.scale.getMax().setColor(maxColor);
        this.firePropertyChange("propertyChanged", old, maxColor);
    }

    public Color getEmptyColor() {
        return this.scale.getEmptyColor();
    }

    public void setEmptyColor(Color color) {
        Color old = this.scale.getEmptyColor();
        this.scale.setEmptyColor(color);
        this.firePropertyChange("propertyChanged", old, color);
    }

    @Override
    public void decorate(ElementDecoration decoration, Object element) {
        decoration.reset();
        Double value = element != null ? this.adapter.getValue(element, this.valueIndex) : Double.valueOf(Double.NaN);
        double v = MatrixUtils.doubleValue(value);
        if (element == null || Double.isNaN(v)) {
            decoration.setBgColor(this.scale.getEmptyColor());
            decoration.setToolTip("Empty cell");
            return;
        }
        Color color = this.scale.valueColor(v);
        decoration.setBgColor(color);
        decoration.setToolTip(fmt.pvalue(v));
    }

    @Override
    public IColorScale getScale() {
        return this.scale;
    }
}

