/*
 * Decompiled with CFR 0.152.
 */
package org.gitools.model.decorator.impl;

import edu.upf.bg.colorscale.IColorScale;
import java.util.IllegalFormatException;
import org.gitools.matrix.model.element.IElementAdapter;
import org.gitools.model.decorator.ElementDecoration;
import org.gitools.model.decorator.ElementDecorator;

public class FormattedTextElementDecorator
extends ElementDecorator {
    private static final long serialVersionUID = -8595819997133940913L;
    private int valueIndex = -1;
    private String formatString = "%1$s";

    public FormattedTextElementDecorator() {
    }

    public FormattedTextElementDecorator(IElementAdapter elementAdapter) {
        super(elementAdapter);
    }

    public Object clone() {
        FormattedTextElementDecorator obj = null;
        try {
            obj = (FormattedTextElementDecorator)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getFormatString() {
        return this.formatString;
    }

    @Override
    public final int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public final void setValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
        this.firePropertyChange("propertyChanged");
    }

    @Override
    public void decorate(ElementDecoration decoration, Object element) {
        String cellText;
        try {
            cellText = this.valueIndex >= 0 ? String.format(this.formatString, this.adapter.getValue(element, this.valueIndex)) : String.format(this.formatString, element);
        }
        catch (IllegalFormatException e) {
            cellText = element.toString();
        }
        decoration.setText(cellText);
        decoration.setToolTip(cellText);
    }

    @Override
    public IColorScale getScale() {
        return null;
    }
}

